/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.table;

import alluxio.Client;
import alluxio.client.table.RetryHandlingTableMasterClient;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.table.ColumnStatisticsInfo;
import alluxio.grpc.table.Constraint;
import alluxio.grpc.table.Database;
import alluxio.grpc.table.Partition;
import alluxio.grpc.table.SyncStatus;
import alluxio.grpc.table.TableInfo;
import alluxio.grpc.table.TransformJobInfo;
import alluxio.master.MasterClientContext;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.List;
import java.util.Map;

@ThreadSafe
public interface TableMasterClient
extends Client {
    public List<String> getAllDatabases() throws AlluxioStatusException;

    public Database getDatabase(String var1) throws AlluxioStatusException;

    public List<String> getAllTables(String var1) throws AlluxioStatusException;

    public TableInfo getTable(String var1, String var2) throws AlluxioStatusException;

    public SyncStatus attachDatabase(String var1, String var2, String var3, String var4, Map<String, String> var5, boolean var6) throws AlluxioStatusException;

    public boolean detachDatabase(String var1) throws AlluxioStatusException;

    public SyncStatus syncDatabase(String var1) throws AlluxioStatusException;

    public List<Partition> readTable(String var1, String var2, Constraint var3) throws AlluxioStatusException;

    public List<ColumnStatisticsInfo> getTableColumnStatistics(String var1, String var2, List<String> var3) throws AlluxioStatusException;

    public List<String> getPartitionNames(String var1, String var2) throws AlluxioStatusException;

    public Map<String, List<ColumnStatisticsInfo>> getPartitionColumnStatistics(String var1, String var2, List<String> var3, List<String> var4) throws AlluxioStatusException;

    public long transformTable(String var1, String var2, String var3) throws AlluxioStatusException;

    public TransformJobInfo getTransformJobInfo(long var1) throws AlluxioStatusException;

    public List<TransformJobInfo> getAllTransformJobInfo() throws AlluxioStatusException;

    public static class Factory {
        private Factory() {
        }

        public static TableMasterClient create(MasterClientContext conf) {
            return new RetryHandlingTableMasterClient(conf);
        }
    }
}

