/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.evictor;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.evictor.CacheEvictor;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.ThreadSafe;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LFUCacheEvictor
implements CacheEvictor {
    private static final Logger LOG = LoggerFactory.getLogger(LFUCacheEvictor.class);
    private static final int PAGE_MAP_INIT_CAPACITY = 200;
    private static final float PAGE_MAP_INIT_LOAD_FACTOR = 0.75f;
    private static final int BUCKET_MAP_INIT_CAPACITY = 32;
    private static final float BUCKET_MAP_INIT_LOAD_FACTOR = 0.75f;
    private static final int BUCKET_LRU_PAGE_MAP_INIT_CAPACITY = 200;
    private static final float BUCKET_LRU_PAGE_MAP_INIT_LOAD_FACTOR = 0.75f;
    private static final boolean UNUSED_MAP_VALUE = true;
    private final Map<PageId, Integer> mPageMap = new HashMap<PageId, Integer>(200, 0.75f);
    private final Map<Integer, Map<PageId, Boolean>> mBucketMap = new HashMap<Integer, Map<PageId, Boolean>>(32, 0.75f);
    private int mMinBucket = -1;
    private final double mDivisor;

    public LFUCacheEvictor(AlluxioConfiguration conf) {
        this.mDivisor = Math.log(conf.getDouble(PropertyKey.USER_CLIENT_CACHE_EVICTOR_LFU_LOGBASE));
    }

    private int getBucket(int count) {
        return (int)(Math.log(count) / this.mDivisor);
    }

    private void addPageToBucket(PageId pageId, int bucket) {
        this.mBucketMap.compute(bucket, (bucketKey, lruMap) -> {
            Map map = lruMap == null ? new LinkedHashMap(200, 0.75f, true) : lruMap;
            map.put(pageId, true);
            return map;
        });
        LOG.debug("added page {} to bucket {}", (Object)pageId, (Object)bucket);
    }

    private Map<PageId, Boolean> removePageFromBucket(PageId pageId, int bucket) {
        return this.mBucketMap.computeIfPresent(bucket, (bucketKey, lruMap) -> {
            if (lruMap.remove(pageId) == null) {
                LOG.debug("cannot remove page {} because it is not found in bucket {}", (Object)pageId, (Object)bucket);
            } else {
                LOG.debug("removed page {} from bucket {}", (Object)pageId, (Object)bucket);
            }
            return lruMap.isEmpty() ? null : lruMap;
        });
    }

    private void touchPageInBucket(PageId pageId, int bucket) {
        this.mBucketMap.computeIfPresent(bucket, (bucketKey, lruMap) -> {
            if (lruMap.get(pageId) == null) {
                LOG.debug("cannot touch page {} - page was not found in bucket {}", (Object)pageId, (Object)bucket);
            } else {
                LOG.debug("touched page {} in bucket {}", (Object)pageId, (Object)bucket);
            }
            return lruMap;
        });
    }

    @Override
    public synchronized void updateOnGet(PageId pageId) {
        int newCount = this.mPageMap.compute(pageId, (id, count) -> count == null ? 1 : count + 1);
        int newBucket = this.getBucket(newCount);
        if (newCount > 1) {
            int oldBucket = this.getBucket(newCount - 1);
            if (newBucket != oldBucket) {
                Map<PageId, Boolean> pagesLeft = this.removePageFromBucket(pageId, oldBucket);
                if (pagesLeft == null && oldBucket == this.mMinBucket) {
                    this.mMinBucket = newBucket;
                }
                this.addPageToBucket(pageId, newBucket);
            } else {
                this.touchPageInBucket(pageId, newBucket);
            }
        } else {
            this.mMinBucket = newBucket;
            this.addPageToBucket(pageId, newBucket);
        }
    }

    @Override
    public void updateOnPut(PageId pageId) {
        this.updateOnGet(pageId);
    }

    @Override
    public synchronized void updateOnDelete(PageId pageId) {
        Integer count = this.mPageMap.remove(pageId);
        if (count == null) {
            LOG.debug("cannot delete page {} - page not found", (Object)pageId);
            return;
        }
        int bucket = this.getBucket(count);
        Map<PageId, Boolean> pagesLeft = this.removePageFromBucket(pageId, bucket);
        if (pagesLeft == null && bucket == this.mMinBucket && !this.mBucketMap.isEmpty()) {
            while (!this.mBucketMap.containsKey(this.mMinBucket)) {
                ++this.mMinBucket;
            }
        }
    }

    @Override
    @Nullable
    public synchronized PageId evict() {
        Map<PageId, Boolean> lruMap = this.mBucketMap.get(this.mMinBucket);
        if (lruMap == null) {
            LOG.debug("cannot evict page - bucket {} is empty", (Object)this.mMinBucket);
            return null;
        }
        PageId pageToEvict = lruMap.keySet().iterator().next();
        LOG.debug("plan to evict page {} ", (Object)pageToEvict);
        return pageToEvict;
    }

    @Override
    public synchronized void reset() {
        this.mPageMap.clear();
        this.mBucketMap.clear();
        this.mMinBucket = -1;
    }
}

