/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.test.profiler;

import org.activiti.engine.impl.interceptor.AbstractCommandInterceptor;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.activiti.engine.test.profiler.ActivitiProfiler;
import org.activiti.engine.test.profiler.CommandExecutionResult;
import org.activiti.engine.test.profiler.ProfileSession;

public class TotalExecutionTimeCommandInterceptor
extends AbstractCommandInterceptor {
    protected ActivitiProfiler activitiProfiler = ActivitiProfiler.getInstance();

    @Override
    public <T> T execute(CommandConfig config, Command<T> command) {
        ProfileSession currentProfileSession = this.activitiProfiler.getCurrentProfileSession();
        if (currentProfileSession != null) {
            String className = command.getClass().getName();
            CommandExecutionResult commandExecutionResult = new CommandExecutionResult();
            currentProfileSession.setCurrentCommandExecution(commandExecutionResult);
            commandExecutionResult.setCommandFqn(className);
            long start = System.currentTimeMillis();
            T result = this.next.execute(config, command);
            long end = System.currentTimeMillis();
            long totalTime = end - start;
            commandExecutionResult.setTotalTimeInMs(totalTime);
            currentProfileSession.addCommandExecution(className, commandExecutionResult);
            currentProfileSession.clearCurrentCommandExecution();
            return result;
        }
        return this.next.execute(config, command);
    }
}

