/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.ActivitiWrongDbException;
import org.activiti.engine.impl.DeploymentQueryImpl;
import org.activiti.engine.impl.ExecutionQueryImpl;
import org.activiti.engine.impl.GroupQueryImpl;
import org.activiti.engine.impl.HistoricActivityInstanceQueryImpl;
import org.activiti.engine.impl.HistoricDetailQueryImpl;
import org.activiti.engine.impl.HistoricProcessInstanceQueryImpl;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.HistoricVariableInstanceQueryImpl;
import org.activiti.engine.impl.JobQueryImpl;
import org.activiti.engine.impl.ModelQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.ProcessDefinitionQueryImpl;
import org.activiti.engine.impl.ProcessInstanceQueryImpl;
import org.activiti.engine.impl.TaskQueryImpl;
import org.activiti.engine.impl.UserQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.ActivitiVersion;
import org.activiti.engine.impl.db.BulkDeleteOperation;
import org.activiti.engine.impl.db.DbSqlSessionFactory;
import org.activiti.engine.impl.db.EntityDependencyOrder;
import org.activiti.engine.impl.db.HasRevision;
import org.activiti.engine.impl.db.ListQueryParameterObject;
import org.activiti.engine.impl.db.upgrade.DbUpgradeStep;
import org.activiti.engine.impl.interceptor.Session;
import org.activiti.engine.impl.persistence.cache.CachedEntity;
import org.activiti.engine.impl.persistence.cache.EntityCache;
import org.activiti.engine.impl.persistence.entity.Entity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.PropertyEntity;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSqlSession
implements Session {
    private static final Logger log = LoggerFactory.getLogger(DbSqlSession.class);
    protected static final Pattern CLEAN_VERSION_REGEX = Pattern.compile("\\d\\.\\d*");
    protected static final String LAST_V5_VERSION = "5.99.0.0";
    protected static final List<ActivitiVersion> ACTIVITI_VERSIONS = new ArrayList<ActivitiVersion>();
    protected SqlSession sqlSession;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected EntityCache entityCache;
    protected Map<Class<? extends Entity>, Map<String, Entity>> insertedObjects = new HashMap<Class<? extends Entity>, Map<String, Entity>>();
    protected Map<Class<? extends Entity>, Map<String, Entity>> deletedObjects = new HashMap<Class<? extends Entity>, Map<String, Entity>>();
    protected Map<Class<? extends Entity>, List<BulkDeleteOperation>> bulkDeleteOperations = new HashMap<Class<? extends Entity>, List<BulkDeleteOperation>>();
    protected List<Entity> updatedObjects = new ArrayList<Entity>();
    protected String connectionMetadataDefaultCatalog;
    protected String connectionMetadataDefaultSchema;
    public static String[] JDBC_METADATA_TABLE_TYPES;

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, EntityCache entityCache) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession();
        this.entityCache = entityCache;
        this.connectionMetadataDefaultCatalog = dbSqlSessionFactory.getDatabaseCatalog();
        this.connectionMetadataDefaultSchema = dbSqlSessionFactory.getDatabaseSchema();
    }

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, EntityCache entityCache, Connection connection, String catalog, String schema) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession(connection);
        this.entityCache = entityCache;
        this.connectionMetadataDefaultCatalog = catalog;
        this.connectionMetadataDefaultSchema = schema;
    }

    public void insert(Entity entity) {
        Class<?> clazz;
        if (entity.getId() == null) {
            String id = this.dbSqlSessionFactory.getIdGenerator().getNextId();
            entity.setId(id);
        }
        if (!this.insertedObjects.containsKey(clazz = entity.getClass())) {
            this.insertedObjects.put(clazz, new LinkedHashMap());
        }
        this.insertedObjects.get(clazz).put(entity.getId(), entity);
        this.entityCache.put(entity, false);
        entity.setInserted(true);
    }

    public void update(Entity entity) {
        this.entityCache.put(entity, false);
        entity.setUpdated(true);
    }

    public int update(String statement, Object parameters) {
        String updateStatement = this.dbSqlSessionFactory.mapStatement(statement);
        return this.getSqlSession().update(updateStatement, parameters);
    }

    public void delete(String statement, Object parameter, Class<? extends Entity> entityClass) {
        if (!this.bulkDeleteOperations.containsKey(entityClass)) {
            this.bulkDeleteOperations.put(entityClass, new ArrayList(1));
        }
        this.bulkDeleteOperations.get(entityClass).add(new BulkDeleteOperation(this.dbSqlSessionFactory.mapStatement(statement), parameter));
    }

    public void delete(Entity entity) {
        Class<?> clazz = entity.getClass();
        if (!this.deletedObjects.containsKey(clazz)) {
            this.deletedObjects.put(clazz, new LinkedHashMap());
        }
        this.deletedObjects.get(clazz).put(entity.getId(), entity);
        entity.setDeleted(true);
    }

    public List selectList(String statement) {
        return this.selectList(statement, null, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter) {
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE);
    }

    public List selectList(String statement, Object parameter, boolean useCache) {
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE, useCache);
    }

    public List selectList(String statement, Object parameter, Page page) {
        return this.selectList(statement, parameter, page, true);
    }

    public List selectList(String statement, Object parameter, Page page, boolean useCache) {
        if (page != null) {
            return this.selectList(statement, parameter, page.getFirstResult(), page.getMaxResults(), useCache);
        }
        return this.selectList(statement, parameter, 0, Integer.MAX_VALUE, useCache);
    }

    public List selectList(String statement, ListQueryParameterObject parameter, Page page) {
        return this.selectList(statement, parameter, page, true);
    }

    public List selectList(String statement, ListQueryParameterObject parameter, Page page, boolean useCache) {
        ListQueryParameterObject parameterToUse = parameter;
        if (parameterToUse == null) {
            parameterToUse = new ListQueryParameterObject();
        }
        if (page != null) {
            parameterToUse.setFirstResult(page.getFirstResult());
            parameterToUse.setMaxResults(page.getMaxResults());
        }
        return this.selectList(statement, parameterToUse, useCache);
    }

    public List selectList(String statement, Object parameter, int firstResult, int maxResults) {
        return this.selectList(statement, parameter, firstResult, maxResults, true);
    }

    public List selectList(String statement, Object parameter, int firstResult, int maxResults, boolean useCache) {
        return this.selectList(statement, new ListQueryParameterObject(parameter, firstResult, maxResults), useCache);
    }

    public List selectList(String statement, ListQueryParameterObject parameter) {
        return this.selectList(statement, parameter, true);
    }

    public List selectList(String statement, ListQueryParameterObject parameter, boolean useCache) {
        return this.selectListWithRawParameter(statement, parameter, parameter.getFirstResult(), parameter.getMaxResults(), useCache);
    }

    public List selectListWithRawParameter(String statement, Object parameter, int firstResult, int maxResults) {
        return this.selectListWithRawParameter(statement, parameter, firstResult, maxResults, true);
    }

    public List selectListWithRawParameter(String statement, Object parameter, int firstResult, int maxResults, boolean useCache) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        if (firstResult == -1 || maxResults == -1) {
            return Collections.EMPTY_LIST;
        }
        List loadedObjects = this.sqlSession.selectList(statement, parameter);
        if (useCache) {
            return this.cacheLoadOrStore(loadedObjects);
        }
        return loadedObjects;
    }

    public List selectListWithRawParameterWithoutFilter(String statement, Object parameter, int firstResult, int maxResults) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        if (firstResult == -1 || maxResults == -1) {
            return Collections.EMPTY_LIST;
        }
        return this.sqlSession.selectList(statement, parameter);
    }

    public Object selectOne(String statement, Object parameter) {
        Object result = this.sqlSession.selectOne(statement = this.dbSqlSessionFactory.mapStatement(statement), parameter);
        if (result instanceof Entity) {
            Entity loadedObject = (Entity)result;
            result = this.cacheLoadOrStore(loadedObject);
        }
        return result;
    }

    public <T extends Entity> T selectById(Class<T> entityClass, String id) {
        return this.selectById(entityClass, id, true);
    }

    public <T extends Entity> T selectById(Class<T> entityClass, String id, boolean useCache) {
        Entity entity = null;
        if (useCache && (entity = (Entity)this.entityCache.findInCache(entityClass, id)) != null) {
            return (T)entity;
        }
        String selectStatement = this.dbSqlSessionFactory.getSelectStatement(entityClass);
        entity = (Entity)this.sqlSession.selectOne(selectStatement = this.dbSqlSessionFactory.mapStatement(selectStatement), (Object)id);
        if (entity == null) {
            return null;
        }
        this.entityCache.put(entity, true);
        return (T)entity;
    }

    protected List cacheLoadOrStore(List<Object> loadedObjects) {
        if (loadedObjects.isEmpty()) {
            return loadedObjects;
        }
        if (!(loadedObjects.get(0) instanceof Entity)) {
            return loadedObjects;
        }
        ArrayList<Entity> filteredObjects = new ArrayList<Entity>(loadedObjects.size());
        for (Object loadedObject : loadedObjects) {
            Entity cachedEntity = this.cacheLoadOrStore((Entity)loadedObject);
            filteredObjects.add(cachedEntity);
        }
        return filteredObjects;
    }

    protected Entity cacheLoadOrStore(Entity entity) {
        Entity cachedEntity = (Entity)this.entityCache.findInCache(entity.getClass(), entity.getId());
        if (cachedEntity != null) {
            return cachedEntity;
        }
        this.entityCache.put(entity, true);
        return entity;
    }

    @Override
    public void flush() {
        this.determineUpdatedObjects();
        this.removeUnnecessaryOperations();
        if (log.isDebugEnabled()) {
            this.debugFlush();
        }
        this.flushInserts();
        this.flushUpdates();
        this.flushDeletes();
    }

    protected void removeUnnecessaryOperations() {
        for (Class<? extends Entity> entityClass : this.deletedObjects.keySet()) {
            HashSet<String> ids = new HashSet<String>();
            Iterator<Entity> entitiesToDeleteIterator = this.deletedObjects.get(entityClass).values().iterator();
            while (entitiesToDeleteIterator.hasNext()) {
                Entity entityToDelete = entitiesToDeleteIterator.next();
                if (!ids.contains(entityToDelete.getId())) {
                    ids.add(entityToDelete.getId());
                    continue;
                }
                entitiesToDeleteIterator.remove();
            }
            for (String id : ids) {
                if (!this.insertedObjects.containsKey(entityClass) || !this.insertedObjects.get(entityClass).containsKey(id)) continue;
                this.insertedObjects.get(entityClass).remove(id);
                this.deletedObjects.get(entityClass).remove(id);
            }
        }
    }

    public void determineUpdatedObjects() {
        this.updatedObjects = new ArrayList<Entity>();
        Map<Class<?>, Map<String, CachedEntity>> cachedObjects = this.entityCache.getAllCachedEntities();
        for (Class<?> clazz : cachedObjects.keySet()) {
            Map<String, CachedEntity> classCache = cachedObjects.get(clazz);
            for (CachedEntity cachedObject : classCache.values()) {
                Entity cachedEntity = cachedObject.getEntity();
                if (this.isEntityInserted(cachedEntity) || !ExecutionEntity.class.isAssignableFrom(cachedEntity.getClass()) && this.isEntityToBeDeleted(cachedEntity) || !cachedObject.hasChanged()) continue;
                this.updatedObjects.add(cachedEntity);
            }
        }
    }

    protected void debugFlush() {
        log.debug("Flushing dbSqlSession");
        int nrOfInserts = 0;
        int nrOfUpdates = 0;
        int nrOfDeletes = 0;
        for (Map<String, Entity> map : this.insertedObjects.values()) {
            for (Entity insertedObject : map.values()) {
                log.debug("  insert {}", (Object)insertedObject);
                ++nrOfInserts;
            }
        }
        for (Entity entity : this.updatedObjects) {
            log.debug("  update {}", (Object)entity);
            ++nrOfUpdates;
        }
        for (Map map : this.deletedObjects.values()) {
            for (Entity deletedObject : map.values()) {
                log.debug("  delete {} with id {}", (Object)deletedObject, (Object)deletedObject.getId());
                ++nrOfDeletes;
            }
        }
        for (Collection collection : this.bulkDeleteOperations.values()) {
            for (BulkDeleteOperation bulkDeleteOperation : collection) {
                log.debug("  {}", (Object)bulkDeleteOperation);
                ++nrOfDeletes;
            }
        }
        log.debug("flush summary: {} insert, {} update, {} delete.", new Object[]{nrOfInserts, nrOfUpdates, nrOfDeletes});
        log.debug("now executing flush...");
    }

    public boolean isEntityInserted(Entity entity) {
        return this.insertedObjects.containsKey(entity.getClass()) && this.insertedObjects.get(entity.getClass()).containsKey(entity.getId());
    }

    public boolean isEntityToBeDeleted(Entity entity) {
        return this.deletedObjects.containsKey(entity.getClass()) && this.deletedObjects.get(entity.getClass()).containsKey(entity.getId());
    }

    protected void flushInserts() {
        if (this.insertedObjects.size() == 0) {
            return;
        }
        for (Class<? extends Entity> entityClass : EntityDependencyOrder.INSERT_ORDER) {
            if (!this.insertedObjects.containsKey(entityClass)) continue;
            this.flushInsertEntities(entityClass, this.insertedObjects.get(entityClass).values());
            this.insertedObjects.remove(entityClass);
        }
        if (this.insertedObjects.size() > 0) {
            for (Class<? extends Entity> entityClass : this.insertedObjects.keySet()) {
                this.flushInsertEntities(entityClass, this.insertedObjects.get(entityClass).values());
            }
        }
        this.insertedObjects.clear();
    }

    protected void flushInsertEntities(Class<? extends Entity> entityClass, Collection<Entity> entitiesToInsert) {
        if (entitiesToInsert.size() == 1) {
            this.flushRegularInsert(entitiesToInsert.iterator().next(), entityClass);
        } else if (Boolean.FALSE.equals(this.dbSqlSessionFactory.isBulkInsertable(entityClass))) {
            for (Entity entity : entitiesToInsert) {
                this.flushRegularInsert(entity, entityClass);
            }
        } else {
            this.flushBulkInsert(entitiesToInsert, entityClass);
        }
    }

    protected Collection<Entity> orderExecutionEntities(Map<String, Entity> executionEntities, boolean parentBeforeChildExecution) {
        ArrayList<Entity> result = new ArrayList<Entity>(executionEntities.size());
        HashMap<String, String> childToParentExecutionMapping = new HashMap<String, String>();
        HashMap<String, List<ExecutionEntity>> parentToChildrenMapping = new HashMap<String, List<ExecutionEntity>>();
        Collection<Entity> executionCollection = executionEntities.values();
        for (ExecutionEntity executionEntity : executionCollection) {
            String string = executionEntity.getParentId();
            String superExecutionId = executionEntity.getSuperExecutionId();
            String parentKey = string != null ? string : superExecutionId;
            childToParentExecutionMapping.put(executionEntity.getId(), parentKey);
            if (!parentToChildrenMapping.containsKey(parentKey)) {
                parentToChildrenMapping.put(parentKey, new ArrayList());
            }
            ((List)parentToChildrenMapping.get(parentKey)).add(executionEntity);
        }
        HashSet<String> hashSet = new HashSet<String>(executionEntities.size());
        for (ExecutionEntity executionEntity : executionCollection) {
            String executionId = executionEntity.getId();
            if (hashSet.contains(executionId)) continue;
            String parentId = (String)childToParentExecutionMapping.get(executionId);
            if (parentId != null) {
                String newParentId;
                while (parentId != null && (newParentId = (String)childToParentExecutionMapping.get(parentId)) != null) {
                    parentId = newParentId;
                }
            }
            if (parentId == null) {
                parentId = executionId;
            }
            if (executionEntities.containsKey(parentId) && !hashSet.contains(parentId)) {
                hashSet.add(parentId);
                if (parentBeforeChildExecution) {
                    result.add(executionEntities.get(parentId));
                } else {
                    result.add(0, executionEntities.get(parentId));
                }
            }
            this.collectChildExecutionsForInsertion(result, parentToChildrenMapping, hashSet, parentId, parentBeforeChildExecution);
        }
        return result;
    }

    protected void collectChildExecutionsForInsertion(List<Entity> result, Map<String, List<ExecutionEntity>> parentToChildrenMapping, Set<String> handledExecutionIds, String parentId, boolean parentBeforeChildExecution) {
        List<ExecutionEntity> childExecutionEntities = parentToChildrenMapping.get(parentId);
        if (childExecutionEntities == null) {
            return;
        }
        for (ExecutionEntity childExecutionEntity : childExecutionEntities) {
            handledExecutionIds.add(childExecutionEntity.getId());
            if (parentBeforeChildExecution) {
                result.add(childExecutionEntity);
            } else {
                result.add(0, childExecutionEntity);
            }
            this.collectChildExecutionsForInsertion(result, parentToChildrenMapping, handledExecutionIds, childExecutionEntity.getId(), parentBeforeChildExecution);
        }
    }

    protected void flushRegularInsert(Entity entity, Class<? extends Entity> clazz) {
        String insertStatement = this.dbSqlSessionFactory.getInsertStatement(entity);
        if ((insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement)) == null) {
            throw new ActivitiException("no insert statement for " + entity.getClass() + " in the ibatis mapping files");
        }
        log.debug("inserting: {}", (Object)entity);
        this.sqlSession.insert(insertStatement, (Object)entity);
        if (entity instanceof HasRevision) {
            this.incrementRevision(entity);
        }
    }

    protected void flushBulkInsert(Collection<Entity> entities, Class<? extends Entity> clazz) {
        String insertStatement = this.dbSqlSessionFactory.getBulkInsertStatement(clazz);
        if ((insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement)) == null) {
            throw new ActivitiException("no insert statement for " + entities.iterator().next().getClass() + " in the ibatis mapping files");
        }
        Iterator<Entity> entityIterator = entities.iterator();
        Boolean hasRevision = null;
        while (entityIterator.hasNext()) {
            ArrayList<Entity> subList = new ArrayList<Entity>();
            for (int index = 0; entityIterator.hasNext() && index < this.dbSqlSessionFactory.getMaxNrOfStatementsInBulkInsert(); ++index) {
                Entity entity = entityIterator.next();
                subList.add(entity);
                if (hasRevision != null) continue;
                hasRevision = entity instanceof HasRevision;
            }
            this.sqlSession.insert(insertStatement, subList);
        }
        if (hasRevision != null && hasRevision.booleanValue()) {
            entityIterator = entities.iterator();
            while (entityIterator.hasNext()) {
                this.incrementRevision(entityIterator.next());
            }
        }
    }

    protected void incrementRevision(Entity insertedObject) {
        HasRevision revisionEntity = (HasRevision)((Object)insertedObject);
        if (revisionEntity.getRevision() == 0) {
            revisionEntity.setRevision(revisionEntity.getRevisionNext());
        }
    }

    protected void flushUpdates() {
        for (Entity updatedObject : this.updatedObjects) {
            String updateStatement = this.dbSqlSessionFactory.getUpdateStatement(updatedObject);
            if ((updateStatement = this.dbSqlSessionFactory.mapStatement(updateStatement)) == null) {
                throw new ActivitiException("no update statement for " + updatedObject.getClass() + " in the ibatis mapping files");
            }
            log.debug("updating: {}", (Object)updatedObject);
            int updatedRecords = this.sqlSession.update(updateStatement, (Object)updatedObject);
            if (updatedRecords == 0) {
                throw new ActivitiOptimisticLockingException(updatedObject + " was updated by another transaction concurrently");
            }
            if (!(updatedObject instanceof HasRevision)) continue;
            ((HasRevision)((Object)updatedObject)).setRevision(((HasRevision)((Object)updatedObject)).getRevisionNext());
        }
        this.updatedObjects.clear();
    }

    protected void flushDeletes() {
        if (this.deletedObjects.size() == 0 && this.bulkDeleteOperations.size() == 0) {
            return;
        }
        for (Class<? extends Entity> entityClass : EntityDependencyOrder.DELETE_ORDER) {
            if (this.deletedObjects.containsKey(entityClass)) {
                this.flushDeleteEntities(entityClass, this.deletedObjects.get(entityClass).values());
                this.deletedObjects.remove(entityClass);
            }
            this.flushBulkDeletes(entityClass);
        }
        if (this.deletedObjects.size() > 0) {
            for (Class<? extends Entity> entityClass : this.deletedObjects.keySet()) {
                this.flushDeleteEntities(entityClass, this.deletedObjects.get(entityClass).values());
                this.flushBulkDeletes(entityClass);
            }
        }
        this.deletedObjects.clear();
    }

    protected void flushBulkDeletes(Class<? extends Entity> entityClass) {
        if (this.bulkDeleteOperations.containsKey(entityClass)) {
            for (BulkDeleteOperation bulkDeleteOperation : this.bulkDeleteOperations.get(entityClass)) {
                bulkDeleteOperation.execute(this.sqlSession);
            }
        }
    }

    protected void flushDeleteEntities(Class<? extends Entity> entityClass, Collection<Entity> entitiesToDelete) {
        for (Entity entity : entitiesToDelete) {
            String deleteStatement = this.dbSqlSessionFactory.getDeleteStatement(entity.getClass());
            if ((deleteStatement = this.dbSqlSessionFactory.mapStatement(deleteStatement)) == null) {
                throw new ActivitiException("no delete statement for " + entity.getClass() + " in the ibatis mapping files");
            }
            if (entity instanceof HasRevision) {
                int nrOfRowsDeleted = this.sqlSession.delete(deleteStatement, (Object)entity);
                if (nrOfRowsDeleted != 0) continue;
                throw new ActivitiOptimisticLockingException(entity + " was updated by another transaction concurrently");
            }
            this.sqlSession.delete(deleteStatement, (Object)entity);
        }
    }

    @Override
    public void close() {
        this.sqlSession.close();
    }

    public void commit() {
        this.sqlSession.commit();
    }

    public void rollback() {
        this.sqlSession.rollback();
    }

    public void dbSchemaCheckVersion() {
        try {
            String dbVersion = this.getDbVersion();
            if (!"6.0.0.4".equals(dbVersion)) {
                throw new ActivitiWrongDbException("6.0.0.4", dbVersion);
            }
            String errorMessage = null;
            if (!this.isEngineTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "engine");
            }
            if (this.dbSqlSessionFactory.isDbHistoryUsed() && !this.isHistoryTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "history");
            }
            if (this.dbSqlSessionFactory.isDbIdentityUsed() && !this.isIdentityTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "identity");
            }
            if (errorMessage != null) {
                throw new ActivitiException("Activiti database problem: " + errorMessage);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw new ActivitiException("no activiti tables in db. set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in activiti.cfg.xml for automatic schema creation", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ActivitiException("couldn't get db schema version", e);
        }
        log.debug("activiti db schema check successful");
    }

    protected String addMissingComponent(String missingComponents, String component) {
        if (missingComponents == null) {
            return "Tables missing for component(s) " + component;
        }
        return missingComponents + ", " + component;
    }

    protected String getDbVersion() {
        String selectSchemaVersionStatement = this.dbSqlSessionFactory.mapStatement("selectDbSchemaVersion");
        return (String)this.sqlSession.selectOne(selectSchemaVersionStatement);
    }

    public void dbSchemaCreate() {
        if (this.isEngineTablePresent()) {
            String dbVersion = this.getDbVersion();
            if (!"6.0.0.4".equals(dbVersion)) {
                throw new ActivitiWrongDbException("6.0.0.4", dbVersion);
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
    }

    protected void dbSchemaCreateIdentity() {
        this.executeMandatorySchemaResource("create", "identity");
    }

    protected void dbSchemaCreateHistory() {
        this.executeMandatorySchemaResource("create", "history");
    }

    protected void dbSchemaCreateEngine() {
        this.executeMandatorySchemaResource("create", "engine");
    }

    public void dbSchemaDrop() {
        this.executeMandatorySchemaResource("drop", "engine");
        if (this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
        if (this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.executeMandatorySchemaResource("drop", "identity");
        }
    }

    public void dbSchemaPrune() {
        if (this.isHistoryTablePresent() && !this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
        if (this.isIdentityTablePresent() && this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.executeMandatorySchemaResource("drop", "identity");
        }
    }

    public void executeMandatorySchemaResource(String operation, String component) {
        this.executeSchemaResource(operation, component, this.getResourceForDbOperation(operation, operation, component), false);
    }

    public String dbSchemaUpdate() {
        String feedback = null;
        boolean isUpgradeNeeded = false;
        int matchingVersionIndex = -1;
        if (this.isEngineTablePresent()) {
            PropertyEntity dbVersionProperty = this.selectById(PropertyEntity.class, "schema.version");
            String dbVersion = dbVersionProperty.getValue();
            matchingVersionIndex = this.findMatchingVersionIndex(dbVersion);
            if (matchingVersionIndex < 0 && dbVersion != null && dbVersion.startsWith("5.")) {
                matchingVersionIndex = this.findMatchingVersionIndex(LAST_V5_VERSION);
            }
            if (matchingVersionIndex < 0) {
                throw new ActivitiException("Could not update Activiti database schema: unknown version from database: '" + dbVersion + "'");
            }
            boolean bl = isUpgradeNeeded = matchingVersionIndex != ACTIVITI_VERSIONS.size() - 1;
            if (isUpgradeNeeded) {
                PropertyEntity dbHistoryProperty;
                dbVersionProperty.setValue("6.0.0.4");
                if ("5.0".equals(dbVersion)) {
                    dbHistoryProperty = (PropertyEntity)Context.getCommandContext().getPropertyEntityManager().create();
                    dbHistoryProperty.setName("schema.history");
                    dbHistoryProperty.setValue("create(5.0)");
                    this.insert(dbHistoryProperty);
                } else {
                    dbHistoryProperty = this.selectById(PropertyEntity.class, "schema.history");
                }
                String dbHistoryValue = dbHistoryProperty.getValue() + " upgrade(" + dbVersion + "->" + "6.0.0.4" + ")";
                dbHistoryProperty.setValue(dbHistoryValue);
                this.dbSchemaUpgrade("engine", matchingVersionIndex);
                feedback = "upgraded Activiti from " + dbVersion + " to " + "6.0.0.4";
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (this.isHistoryTablePresent()) {
            if (isUpgradeNeeded) {
                this.dbSchemaUpgrade("history", matchingVersionIndex);
            }
        } else if (this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (this.isIdentityTablePresent()) {
            if (isUpgradeNeeded) {
                this.dbSchemaUpgrade("identity", matchingVersionIndex);
            }
        } else if (this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
        return feedback;
    }

    protected int findMatchingVersionIndex(String dbVersion) {
        int index = 0;
        int matchingVersionIndex = -1;
        while (matchingVersionIndex < 0 && index < ACTIVITI_VERSIONS.size()) {
            if (ACTIVITI_VERSIONS.get(index).matches(dbVersion)) {
                matchingVersionIndex = index;
                continue;
            }
            ++index;
        }
        return matchingVersionIndex;
    }

    public boolean isEngineTablePresent() {
        return this.isTablePresent("ACT_RU_EXECUTION");
    }

    public boolean isHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_PROCINST");
    }

    public boolean isIdentityTablePresent() {
        return this.isTablePresent("ACT_ID_USER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(String tableName) {
        boolean bl;
        String databaseType;
        if (!this.dbSqlSessionFactory.isTablePrefixIsSchema()) {
            tableName = this.prependDatabaseTablePrefix(tableName);
        }
        Connection connection = null;
        connection = this.sqlSession.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet tables = null;
        String catalog = this.connectionMetadataDefaultCatalog;
        if (this.dbSqlSessionFactory.getDatabaseCatalog() != null && this.dbSqlSessionFactory.getDatabaseCatalog().length() > 0) {
            catalog = this.dbSqlSessionFactory.getDatabaseCatalog();
        }
        String schema = this.connectionMetadataDefaultSchema;
        if (this.dbSqlSessionFactory.getDatabaseSchema() != null && this.dbSqlSessionFactory.getDatabaseSchema().length() > 0) {
            schema = this.dbSqlSessionFactory.getDatabaseSchema();
        }
        if ("postgres".equals(databaseType = this.dbSqlSessionFactory.getDatabaseType())) {
            tableName = tableName.toLowerCase();
        }
        if (schema != null && "oracle".equals(databaseType)) {
            schema = schema.toUpperCase();
        }
        if (catalog != null && catalog.length() == 0) {
            catalog = null;
        }
        try {
            tables = databaseMetaData.getTables(catalog, schema, tableName, JDBC_METADATA_TABLE_TYPES);
            bl = tables.next();
        }
        catch (Throwable throwable) {
            try {
                try {
                    tables.close();
                }
                catch (Exception e) {
                    log.error("Error closing meta data tables", (Throwable)e);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ActivitiException("couldn't check if tables are already present using metadata: " + e.getMessage(), e);
            }
        }
        try {
            tables.close();
        }
        catch (Exception e) {
            log.error("Error closing meta data tables", (Throwable)e);
        }
        return bl;
    }

    protected boolean isUpgradeNeeded(String versionInDatabase) {
        if ("6.0.0.4".equals(versionInDatabase)) {
            return false;
        }
        String cleanDbVersion = this.getCleanVersion(versionInDatabase);
        String[] cleanDbVersionSplitted = cleanDbVersion.split("\\.");
        int dbMajorVersion = Integer.valueOf(cleanDbVersionSplitted[0]);
        int dbMinorVersion = Integer.valueOf(cleanDbVersionSplitted[1]);
        String cleanEngineVersion = this.getCleanVersion("6.0.0.4");
        String[] cleanEngineVersionSplitted = cleanEngineVersion.split("\\.");
        int engineMajorVersion = Integer.valueOf(cleanEngineVersionSplitted[0]);
        int engineMinorVersion = Integer.valueOf(cleanEngineVersionSplitted[1]);
        if (dbMajorVersion > engineMajorVersion || dbMajorVersion <= engineMajorVersion && dbMinorVersion > engineMinorVersion) {
            throw new ActivitiException("Version of activiti database (" + versionInDatabase + ") is more recent than the engine (" + "6.0.0.4" + ")");
        }
        if (cleanDbVersion.compareTo(cleanEngineVersion) == 0) {
            log.warn("Engine-version is the same, but not an exact match: {} vs. {}. Not performing database-upgrade.", (Object)versionInDatabase, (Object)"6.0.0.4");
            return false;
        }
        return true;
    }

    protected String getCleanVersion(String versionString) {
        Matcher matcher = CLEAN_VERSION_REGEX.matcher(versionString);
        if (!matcher.find()) {
            throw new ActivitiException("Illegal format for version: " + versionString);
        }
        String cleanString = matcher.group();
        try {
            Double.parseDouble(cleanString);
            return cleanString;
        }
        catch (NumberFormatException nfe) {
            throw new ActivitiException("Illegal format for version: " + versionString);
        }
    }

    protected String prependDatabaseTablePrefix(String tableName) {
        return this.dbSqlSessionFactory.getDatabaseTablePrefix() + tableName;
    }

    protected void dbSchemaUpgrade(String component, int currentDatabaseVersionsIndex) {
        ActivitiVersion activitiVersion = ACTIVITI_VERSIONS.get(currentDatabaseVersionsIndex);
        String dbVersion = activitiVersion.getMainVersion();
        log.info("upgrading activiti {} schema from {} to {}", new Object[]{component, dbVersion, "6.0.0.4"});
        for (int i = currentDatabaseVersionsIndex + 1; i < ACTIVITI_VERSIONS.size(); ++i) {
            String nextVersion = ACTIVITI_VERSIONS.get(i).getMainVersion();
            if (nextVersion.endsWith("-SNAPSHOT")) {
                nextVersion = nextVersion.substring(0, nextVersion.length() - "-SNAPSHOT".length());
            }
            dbVersion = dbVersion.replace(".", "");
            nextVersion = nextVersion.replace(".", "");
            log.info("Upgrade needed: {} -> {}. Looking for schema update resource for component '{}'", new Object[]{dbVersion, nextVersion, component});
            this.executeSchemaResource("upgrade", component, this.getResourceForDbOperation("upgrade", "upgradestep." + dbVersion + ".to." + nextVersion, component), true);
            dbVersion = nextVersion;
        }
    }

    public String getResourceForDbOperation(String directory, String operation, String component) {
        String databaseType = this.dbSqlSessionFactory.getDatabaseType();
        return "org/activiti/db/" + directory + "/activiti." + databaseType + "." + operation + "." + component + ".sql";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeSchemaResource(String operation, String component, String resourceName, boolean isOptional) {
        InputStream inputStream = null;
        try {
            inputStream = ReflectUtil.getResourceAsStream(resourceName);
            if (inputStream == null) {
                if (!isOptional) throw new ActivitiException("resource '" + resourceName + "' is not available");
                log.info("no schema resource {} for {}", (Object)resourceName, (Object)operation);
                return;
            } else {
                this.executeSchemaResource(operation, component, resourceName, inputStream);
            }
            return;
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSchemaResource(String operation, String component, String resourceName, InputStream inputStream) {
        log.info("performing {} on {} with resource {}", new Object[]{operation, component, resourceName});
        String sqlStatement = null;
        String exceptionSqlStatement = null;
        try {
            Connection connection = this.sqlSession.getConnection();
            Exception exception = null;
            byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
            String ddlStatements = new String(bytes);
            try {
                if (this.isMysql()) {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    int majorVersion = databaseMetaData.getDatabaseMajorVersion();
                    int minorVersion = databaseMetaData.getDatabaseMinorVersion();
                    log.info("Found MySQL: majorVersion=" + majorVersion + " minorVersion=" + minorVersion);
                    if (majorVersion <= 5 && minorVersion < 6) {
                        ddlStatements = this.updateDdlForMySqlVersionLowerThan56(ddlStatements);
                    }
                }
            }
            catch (Exception e) {
                log.info("Could not get database metadata", (Throwable)e);
            }
            BufferedReader reader = new BufferedReader(new StringReader(ddlStatements));
            String line = this.readNextTrimmedLine(reader);
            boolean inOraclePlsqlBlock = false;
            while (line != null) {
                if (line.startsWith("# ")) {
                    log.debug(line.substring(2));
                } else if (line.startsWith("-- ")) {
                    log.debug(line.substring(3));
                } else {
                    if (line.startsWith("execute java ")) {
                        String upgradestepClassName = line.substring(13).trim();
                        DbUpgradeStep dbUpgradeStep = null;
                        try {
                            dbUpgradeStep = (DbUpgradeStep)ReflectUtil.instantiate(upgradestepClassName);
                        }
                        catch (ActivitiException e) {
                            throw new ActivitiException("database update java class '" + upgradestepClassName + "' can't be instantiated: " + e.getMessage(), e);
                        }
                        try {
                            log.debug("executing upgrade step java class {}", (Object)upgradestepClassName);
                            dbUpgradeStep.execute(this);
                        }
                        catch (Exception e) {
                            throw new ActivitiException("error while executing database update java class '" + upgradestepClassName + "': " + e.getMessage(), e);
                        }
                    }
                    if (line.length() > 0) {
                        if (this.isOracle() && line.startsWith("begin")) {
                            inOraclePlsqlBlock = true;
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                        } else if (line.endsWith(";") && !inOraclePlsqlBlock || line.startsWith("/") && inOraclePlsqlBlock) {
                            if (inOraclePlsqlBlock) {
                                inOraclePlsqlBlock = false;
                            } else {
                                sqlStatement = this.addSqlStatementPiece(sqlStatement, line.substring(0, line.length() - 1));
                            }
                            Statement jdbcStatement = connection.createStatement();
                            try {
                                log.debug("SQL: {}", (Object)sqlStatement);
                                jdbcStatement.execute(sqlStatement);
                                jdbcStatement.close();
                            }
                            catch (Exception e) {
                                if (exception == null) {
                                    exception = e;
                                    exceptionSqlStatement = sqlStatement;
                                }
                                log.error("problem during schema {}, statement {}", new Object[]{operation, sqlStatement, e});
                            }
                            finally {
                                sqlStatement = null;
                            }
                        } else {
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                        }
                    }
                }
                line = this.readNextTrimmedLine(reader);
            }
            if (exception != null) {
                throw exception;
            }
            log.debug("activiti db schema {} for component {} successful", (Object)operation, (Object)component);
        }
        catch (Exception e) {
            throw new ActivitiException("couldn't " + operation + " db schema: " + exceptionSqlStatement, e);
        }
    }

    protected String updateDdlForMySqlVersionLowerThan56(String ddlStatements) {
        return ddlStatements.replace("timestamp(3)", "timestamp").replace("datetime(3)", "datetime").replace("TIMESTAMP(3)", "TIMESTAMP").replace("DATETIME(3)", "DATETIME");
    }

    protected String addSqlStatementPiece(String sqlStatement, String line) {
        if (sqlStatement == null) {
            return line;
        }
        return sqlStatement + " \n" + line;
    }

    protected String readNextTrimmedLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        return line;
    }

    protected boolean isMissingTablesException(Exception e) {
        String exceptionMessage = e.getMessage();
        if (e.getMessage() != null) {
            if (exceptionMessage.indexOf("Table") != -1 && exceptionMessage.indexOf("not found") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("Table") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("doesn't exist") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("relation") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("does not exist") != -1) {
                return true;
            }
        }
        return false;
    }

    public void performSchemaOperationsProcessEngineBuild() {
        String databaseSchemaUpdate = Context.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        log.debug("Executing performSchemaOperationsProcessEngineBuild with setting " + databaseSchemaUpdate);
        if ("drop-create".equals(databaseSchemaUpdate)) {
            try {
                this.dbSchemaDrop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if ("create-drop".equals(databaseSchemaUpdate) || "drop-create".equals(databaseSchemaUpdate) || "create".equals(databaseSchemaUpdate)) {
            this.dbSchemaCreate();
        } else if ("false".equals(databaseSchemaUpdate)) {
            this.dbSchemaCheckVersion();
        } else if ("true".equals(databaseSchemaUpdate)) {
            this.dbSchemaUpdate();
        }
    }

    public void performSchemaOperationsProcessEngineClose() {
        String databaseSchemaUpdate = Context.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        if ("create-drop".equals(databaseSchemaUpdate)) {
            this.dbSchemaDrop();
        }
    }

    public <T> T getCustomMapper(Class<T> type) {
        return (T)this.sqlSession.getMapper(type);
    }

    public boolean isMysql() {
        return this.dbSqlSessionFactory.getDatabaseType().equals("mysql");
    }

    public boolean isOracle() {
        return this.dbSqlSessionFactory.getDatabaseType().equals("oracle");
    }

    public DeploymentQueryImpl createDeploymentQuery() {
        return new DeploymentQueryImpl();
    }

    public ModelQueryImpl createModelQueryImpl() {
        return new ModelQueryImpl();
    }

    public ProcessDefinitionQueryImpl createProcessDefinitionQuery() {
        return new ProcessDefinitionQueryImpl();
    }

    public ProcessInstanceQueryImpl createProcessInstanceQuery() {
        return new ProcessInstanceQueryImpl();
    }

    public ExecutionQueryImpl createExecutionQuery() {
        return new ExecutionQueryImpl();
    }

    public TaskQueryImpl createTaskQuery() {
        return new TaskQueryImpl();
    }

    public JobQueryImpl createJobQuery() {
        return new JobQueryImpl();
    }

    public HistoricProcessInstanceQueryImpl createHistoricProcessInstanceQuery() {
        return new HistoricProcessInstanceQueryImpl();
    }

    public HistoricActivityInstanceQueryImpl createHistoricActivityInstanceQuery() {
        return new HistoricActivityInstanceQueryImpl();
    }

    public HistoricTaskInstanceQueryImpl createHistoricTaskInstanceQuery() {
        return new HistoricTaskInstanceQueryImpl();
    }

    public HistoricDetailQueryImpl createHistoricDetailQuery() {
        return new HistoricDetailQueryImpl();
    }

    public HistoricVariableInstanceQueryImpl createHistoricVariableInstanceQuery() {
        return new HistoricVariableInstanceQueryImpl();
    }

    public UserQueryImpl createUserQuery() {
        return new UserQueryImpl();
    }

    public GroupQueryImpl createGroupQuery() {
        return new GroupQueryImpl();
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }

    static {
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.7"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.8"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.9"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.10"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.11"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.12", Arrays.asList("5.12.1", "5.12T")));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.13"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.14"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.15"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.15.1"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.16"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.16.1"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.16.2-SNAPSHOT"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.16.2"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.16.3.0"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.16.4.0"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.17.0.0"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.17.0.1"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.17.0.2"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.18.0.0"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.18.0.1"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.20.0.0"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.20.0.1"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.20.0.2"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.21.0.0"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("5.22.0.0"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion(LAST_V5_VERSION));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("6.0.0.0"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("6.0.0.1"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("6.0.0.2"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("6.0.0.3"));
        ACTIVITI_VERSIONS.add(new ActivitiVersion("6.0.0.4"));
        JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE"};
    }
}

