/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.Map;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.impl.cmd.AbstractCompleteTaskCmd;
import org.activiti.engine.impl.form.TaskFormHandler;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.util.Activiti5Util;
import org.activiti.engine.impl.util.FormHandlerUtil;

public class SubmitTaskFormCmd
extends AbstractCompleteTaskCmd {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Map<String, String> properties;
    protected boolean completeTask;

    public SubmitTaskFormCmd(String taskId, Map<String, String> properties, boolean completeTask) {
        super(taskId);
        this.taskId = taskId;
        this.properties = properties;
        this.completeTask = completeTask;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (task.getProcessDefinitionId() != null && Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
            Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
            activiti5CompatibilityHandler.submitTaskFormData(this.taskId, this.properties, this.completeTask);
            return null;
        }
        commandContext.getHistoryManager().recordFormPropertiesSubmitted(task.getExecution(), this.properties, this.taskId);
        TaskFormHandler taskFormHandler = FormHandlerUtil.getTaskFormHandlder(task);
        if (taskFormHandler != null) {
            taskFormHandler.submitFormProperties(this.properties, task.getExecution());
            if (this.completeTask) {
                this.executeTaskComplete(commandContext, task, null, false);
            }
        }
        return null;
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot submit a form to a suspended task";
    }
}

