/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Date;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.util.Activiti5Util;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.apache.commons.lang3.StringUtils;

public class SaveTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected TaskEntity task;

    public SaveTaskCmd(Task task) {
        this.task = (TaskEntity)task;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.task == null) {
            throw new ActivitiIllegalArgumentException("task is null");
        }
        if (this.task.getProcessDefinitionId() != null && Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, this.task.getProcessDefinitionId())) {
            Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
            activiti5CompatibilityHandler.saveTask(this.task);
            return null;
        }
        if (this.task.getRevision() == 0) {
            commandContext.getTaskEntityManager().insert(this.task, null);
            if (commandContext.getEventDispatcher().isEnabled()) {
                commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_CREATED, this.task));
            }
        } else {
            TaskInfo originalTaskEntity = null;
            if (commandContext.getProcessEngineConfiguration().getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
                originalTaskEntity = (TaskInfo)commandContext.getHistoricTaskInstanceEntityManager().findById(this.task.getId());
            }
            if (originalTaskEntity == null) {
                originalTaskEntity = (TaskInfo)commandContext.getTaskEntityManager().findById(this.task.getId());
            }
            String originalName = originalTaskEntity.getName();
            String originalAssignee = originalTaskEntity.getAssignee();
            String originalOwner = originalTaskEntity.getOwner();
            String originalDescription = originalTaskEntity.getDescription();
            Date originalDueDate = originalTaskEntity.getDueDate();
            int originalPriority = originalTaskEntity.getPriority();
            String originalCategory = originalTaskEntity.getCategory();
            String originalFormKey = originalTaskEntity.getFormKey();
            String originalParentTaskId = originalTaskEntity.getParentTaskId();
            String originalTaskDefinitionKey = originalTaskEntity.getTaskDefinitionKey();
            if (commandContext.getProcessEngineConfiguration().getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
                if (!StringUtils.equals((CharSequence)originalName, (CharSequence)this.task.getName())) {
                    commandContext.getHistoryManager().recordTaskNameChange(this.task.getId(), this.task.getName());
                }
                if (!StringUtils.equals((CharSequence)originalDescription, (CharSequence)this.task.getDescription())) {
                    commandContext.getHistoryManager().recordTaskDescriptionChange(this.task.getId(), this.task.getDescription());
                }
                if (originalDueDate == null && this.task.getDueDate() != null || originalDueDate != null && this.task.getDueDate() == null || originalDueDate != null && !originalDueDate.equals(this.task.getDueDate())) {
                    commandContext.getHistoryManager().recordTaskDueDateChange(this.task.getId(), this.task.getDueDate());
                }
                if (originalPriority != this.task.getPriority()) {
                    commandContext.getHistoryManager().recordTaskPriorityChange(this.task.getId(), this.task.getPriority());
                }
                if (!StringUtils.equals((CharSequence)originalCategory, (CharSequence)this.task.getCategory())) {
                    commandContext.getHistoryManager().recordTaskCategoryChange(this.task.getId(), this.task.getCategory());
                }
                if (!StringUtils.equals((CharSequence)originalFormKey, (CharSequence)this.task.getFormKey())) {
                    commandContext.getHistoryManager().recordTaskFormKeyChange(this.task.getId(), this.task.getFormKey());
                }
                if (!StringUtils.equals((CharSequence)originalParentTaskId, (CharSequence)this.task.getParentTaskId())) {
                    commandContext.getHistoryManager().recordTaskParentTaskIdChange(this.task.getId(), this.task.getParentTaskId());
                }
                if (!StringUtils.equals((CharSequence)originalTaskDefinitionKey, (CharSequence)this.task.getTaskDefinitionKey())) {
                    commandContext.getHistoryManager().recordTaskDefinitionKeyChange(this.task.getId(), this.task.getTaskDefinitionKey());
                }
            }
            if (!StringUtils.equals((CharSequence)originalOwner, (CharSequence)this.task.getOwner())) {
                if (this.task.getProcessInstanceId() != null) {
                    commandContext.getIdentityLinkEntityManager().involveUser(this.task.getProcessInstance(), this.task.getOwner(), "participant");
                }
                commandContext.getHistoryManager().recordTaskOwnerChange(this.task.getId(), this.task.getOwner());
            }
            if (!StringUtils.equals((CharSequence)originalAssignee, (CharSequence)this.task.getAssignee())) {
                if (this.task.getProcessInstanceId() != null) {
                    commandContext.getIdentityLinkEntityManager().involveUser(this.task.getProcessInstance(), this.task.getAssignee(), "participant");
                }
                commandContext.getHistoryManager().recordTaskAssigneeChange(this.task.getId(), this.task.getAssignee());
                commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(this.task, "assignment");
                commandContext.getHistoryManager().recordTaskAssignment(this.task);
                if (commandContext.getEventDispatcher().isEnabled()) {
                    commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TASK_ASSIGNED, this.task));
                }
            }
            commandContext.getTaskEntityManager().update(this.task);
        }
        return null;
    }
}

