/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.engine.impl.bpmn.behavior.WebServiceActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTaskParseHandler
extends AbstractActivityBpmnParseHandler<ServiceTask> {
    private static Logger logger = LoggerFactory.getLogger(ServiceTaskParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return ServiceTask.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, ServiceTask serviceTask) {
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getType())) {
            if (serviceTask.getType().equalsIgnoreCase("mail")) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createMailActivityBehavior(serviceTask));
            } else if (serviceTask.getType().equalsIgnoreCase("mule")) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createMuleActivityBehavior(serviceTask));
            } else if (serviceTask.getType().equalsIgnoreCase("camel")) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createCamelActivityBehavior(serviceTask));
            } else if (serviceTask.getType().equalsIgnoreCase("shell")) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createShellActivityBehavior(serviceTask));
            } else if (serviceTask.getType().equalsIgnoreCase("dmn")) {
                serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createDmnActivityBehavior(serviceTask));
            } else {
                logger.warn("Invalid service task type: '" + serviceTask.getType() + "'  for service task " + serviceTask.getId());
            }
        } else if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(serviceTask.getImplementationType())) {
            serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createClassDelegateServiceTask(serviceTask));
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(serviceTask.getImplementationType())) {
            serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createServiceTaskDelegateExpressionActivityBehavior(serviceTask));
        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(serviceTask.getImplementationType())) {
            serviceTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createServiceTaskExpressionActivityBehavior(serviceTask));
        } else if (ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE.equalsIgnoreCase(serviceTask.getImplementationType()) && StringUtils.isNotEmpty((CharSequence)serviceTask.getOperationRef())) {
            WebServiceActivityBehavior webServiceActivityBehavior = bpmnParse.getActivityBehaviorFactory().createWebServiceActivityBehavior(serviceTask);
            serviceTask.setBehavior((Object)webServiceActivityBehavior);
        } else {
            logger.warn("One of the attributes 'class', 'delegateExpression', 'type', 'operation', or 'expression' is mandatory on serviceTask " + serviceTask.getId());
        }
    }
}

