/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.vidageek.mirror.dsl.Matcher;
import net.vidageek.mirror.matcher.GetterMatcher;
import net.vidageek.mirror.matcher.ListFilter;
import net.vidageek.mirror.matcher.SetterMatcher;
import net.vidageek.mirror.provider.ReflectionProvider;
import net.vidageek.mirror.reflect.DefaultAllAnnotationsHandler;
import net.vidageek.mirror.reflect.dsl.AllAnnotationsHandler;
import net.vidageek.mirror.reflect.dsl.AllReflectionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultAllReflectionHandler<T>
implements AllReflectionHandler<T> {
    private final Class<T> clazz;
    private final ReflectionProvider provider;

    public DefaultAllReflectionHandler(ReflectionProvider provider, Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        this.provider = provider;
        this.clazz = clazz;
    }

    @Override
    public List<Field> fields() {
        return this.provider.getClassReflectionProvider(this.clazz).reflectAllFields();
    }

    @Override
    public List<Method> methods() {
        return this.provider.getClassReflectionProvider(this.clazz).reflectAllMethods();
    }

    @Override
    public List<Constructor<T>> constructors() {
        return this.provider.getClassReflectionProvider(this.clazz).reflectAllConstructors();
    }

    @Override
    public AllAnnotationsHandler annotations() {
        return new DefaultAllAnnotationsHandler(this.provider, this.clazz);
    }

    @Override
    public List<Method> setters() {
        return new ListFilter().filter(new SetterMatcher(), this.methods());
    }

    @Override
    public List<Method> getters() {
        return new ListFilter().filter(new GetterMatcher(), this.methods());
    }

    @Override
    public List<Field> fieldsMatching(Matcher<Field> matcher) {
        return new ListFilter().filter(matcher, this.fields());
    }

    @Override
    public List<Method> methodsMatching(Matcher<Method> matcher) {
        return new ListFilter().filter(matcher, this.methods());
    }

    @Override
    public List<Constructor<T>> constructorsMatching(Matcher<Constructor<T>> matcher) {
        return new ListFilter().filter(matcher, this.constructors());
    }

    @Override
    public List<Annotation> annotationsMatching(Matcher<Annotation> matcher) {
        return new ListFilter().filter(matcher, this.annotations().atClass());
    }
}

