/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.provider.java;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.vidageek.mirror.exception.ReflectionProviderException;
import net.vidageek.mirror.provider.MethodReflectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PureJavaMethodReflectionProvider
implements MethodReflectionProvider {
    private final Object target;
    private final Method method;

    public PureJavaMethodReflectionProvider(Object target, Class<?> clazz, Method method) {
        this.target = target;
        this.method = method;
    }

    @Override
    public Class<?>[] getParameters() {
        return this.method.getParameterTypes();
    }

    @Override
    public void setAccessible() {
        this.method.setAccessible(true);
    }

    @Override
    public Object invoke(Object[] args) {
        try {
            this.setAccessible();
            return this.method.invoke(this.target, args);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionProviderException("Could not invoke method " + this.method.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionProviderException("Could not invoke method " + this.method.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionProviderException("Could not invoke method " + this.method.getName(), e.getCause() == null ? e : e.getCause());
        }
        catch (NullPointerException e) {
            throw new ReflectionProviderException("Attempt to call an instance method ( " + this.method.getName() + ") on a null object.", e);
        }
    }
}

