/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.provider.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.vidageek.mirror.exception.ReflectionProviderException;
import net.vidageek.mirror.matcher.ClassArrayMatcher;
import net.vidageek.mirror.matcher.MatchType;
import net.vidageek.mirror.provider.ClassReflectionProvider;
import net.vidageek.mirror.provider.java.FixedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PureJavaClassReflectionProvider<T>
implements ClassReflectionProvider<T> {
    private Class<T> clazz;

    public PureJavaClassReflectionProvider(String className) {
        block2: {
            try {
                this.clazz = Class.forName(className, false, PureJavaClassReflectionProvider.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                this.clazz = FixedType.fromValue(className);
                if (this.clazz != null) break block2;
                throw new ReflectionProviderException("class " + className + " could not be found.", e);
            }
        }
    }

    public PureJavaClassReflectionProvider(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public Class<T> reflectClass() {
        return this.clazz;
    }

    @Override
    public List<Field> reflectAllFields() {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class<T> c = this.clazz; c != null; c = c.getSuperclass()) {
            list.addAll(Arrays.asList(c.getDeclaredFields()));
            for (Class<?> interf : c.getInterfaces()) {
                list.addAll(Arrays.asList(interf.getFields()));
            }
        }
        return list;
    }

    @Override
    public List<Method> reflectAllMethods() {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Class<T> c = this.clazz; c != null; c = c.getSuperclass()) {
            list.addAll(Arrays.asList(c.getDeclaredMethods()));
        }
        return list;
    }

    @Override
    public List<Constructor<T>> reflectAllConstructors() {
        return Arrays.asList(this.clazz.getDeclaredConstructors());
    }

    @Override
    public Constructor<T> reflectConstructor(Class<?>[] argumentTypes) {
        ClassArrayMatcher matcher = new ClassArrayMatcher(argumentTypes);
        Constructor<T> match = null;
        for (Constructor<T> constructor : this.reflectAllConstructors()) {
            MatchType matchType = matcher.match(constructor.getParameterTypes());
            if (MatchType.PERFECT.equals((Object)matchType)) {
                match = constructor;
                break;
            }
            if (!MatchType.MATCH.equals((Object)matchType)) continue;
            match = constructor;
        }
        return match;
    }

    @Override
    public Field reflectField(String fieldName) {
        for (Field f : this.reflectAllFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Method reflectMethod(String methodName, Class<?>[] argumentTypes) {
        ClassArrayMatcher matcher = new ClassArrayMatcher(argumentTypes);
        Method match = null;
        for (Method method : this.reflectAllMethods()) {
            if (!method.getName().equals(methodName)) continue;
            MatchType matchType = matcher.match(method.getParameterTypes());
            if (MatchType.PERFECT.equals((Object)matchType)) {
                match = method;
                break;
            }
            if (!MatchType.MATCH.equals((Object)matchType)) continue;
            match = method;
        }
        return match;
    }
}

