/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.invoke;

import java.lang.reflect.Method;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.exception.MirrorException;
import net.vidageek.mirror.invoke.MethodHandlerByMethod;
import net.vidageek.mirror.invoke.dsl.MethodHandler;
import net.vidageek.mirror.provider.ReflectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodHandlerByName
implements MethodHandler {
    private final Object target;
    private final String methodName;
    private final Class<?> clazz;
    private final ReflectionProvider provider;

    public MethodHandlerByName(ReflectionProvider provider, Object target, Class<?> clazz, String methodName) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz can't be null");
        }
        if (methodName == null || methodName.trim().length() == 0) {
            throw new IllegalArgumentException("methodName can't be null");
        }
        this.provider = provider;
        this.target = target;
        this.clazz = clazz;
        this.methodName = methodName;
    }

    @Override
    public Object withoutArgs() {
        return this.withArgs(new Object[0]);
    }

    @Override
    public Object withArgs(Object ... args) {
        return new MethodHandlerByMethod(this.provider, this.target, this.clazz, this.getMethod(args)).withArgs(args);
    }

    private Method getMethod(Object[] args) {
        int length = args == null ? 0 : args.length;
        Class[] classes = new Class[length];
        for (int i = 0; i < length; ++i) {
            if (args[i] == null) {
                throw new IllegalArgumentException("Cannot invoke a method by name if one of it's arguments is null. First reflect the method.");
            }
            classes[i] = args[i].getClass();
        }
        Method method = new Mirror(this.provider).on(this.clazz).reflect().method(this.methodName).withArgs(classes);
        if (method == null) {
            throw new MirrorException("Could not find method " + this.methodName + " on class " + this.clazz.getName());
        }
        return method;
    }
}

