/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.deployment.ContainerImageCapabilitiesUtil;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.FallbackContainerImageRegistryBuildItem;
import io.quarkus.container.spi.ImageReference;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.SuppressNonRuntimeConfigChangedWarningBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.steps.NativeSourcesBuild;
import java.util.Collections;
import java.util.Optional;
import org.jboss.logging.Logger;

public class ContainerImageProcessor {
    private static final String UNKNOWN_USER = "?";
    private static final Logger log = Logger.getLogger(ContainerImageProcessor.class);

    @BuildStep(onlyIf={NativeSourcesBuild.class})
    void failForNativeSources(BuildProducer<ArtifactResultBuildItem> artifactResultProducer) {
        throw new IllegalArgumentException("The Container Image extensions are incompatible with the 'native-sources' package type.");
    }

    @BuildStep
    public void ignoreCredentialsChange(BuildProducer<SuppressNonRuntimeConfigChangedWarningBuildItem> producer) {
        producer.produce((BuildItem)new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.container-image.username"));
        producer.produce((BuildItem)new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.container-image.password"));
    }

    @BuildStep
    public void publishImageInfo(ApplicationInfoBuildItem app, ContainerImageConfig containerImageConfig, Optional<FallbackContainerImageRegistryBuildItem> containerImageRegistry, Capabilities capabilities, BuildProducer<ContainerImageInfoBuildItem> containerImage) {
        String effectiveGroup;
        this.ensureSingleContainerImageExtension(capabilities);
        if (containerImageConfig.additionalTags.isPresent()) {
            for (String additionalTag : containerImageConfig.additionalTags.get()) {
                if (ImageReference.isValidTag((String)additionalTag)) continue;
                throw new IllegalArgumentException("The supplied additional container-image tag '" + additionalTag + "' is invalid");
            }
        }
        if (UNKNOWN_USER.equals(effectiveGroup = containerImageConfig.getEffectiveGroup().orElse(""))) {
            log.warn((Object)"Can't get the current user name, which is used as default for container image group. Can't publish container image info.");
            return;
        }
        if (containerImageConfig.image.isPresent()) {
            ImageReference imageReference = ImageReference.parse((String)containerImageConfig.image.get());
            String repository = imageReference.getRepository();
            containerImage.produce((BuildItem)new ContainerImageInfoBuildItem(Optional.of(imageReference.getRegistry()), repository, imageReference.getTag(), containerImageConfig.additionalTags.orElse(Collections.emptyList())));
            return;
        }
        String registry = containerImageConfig.registry.orElseGet(() -> containerImageRegistry.map(FallbackContainerImageRegistryBuildItem::getRegistry).orElse(null));
        if (registry != null && !ImageReference.isValidRegistry((String)registry)) {
            throw new IllegalArgumentException("The supplied container-image registry '" + registry + "' is invalid");
        }
        String effectiveName = containerImageConfig.name.orElse(app.getName());
        String repository = containerImageConfig.getEffectiveGroup().map(s -> s + "/").orElse("") + effectiveName;
        if (!ImageReference.isValidRepository((String)repository)) {
            throw new IllegalArgumentException("The supplied combination of container-image group '" + effectiveGroup + "' and name '" + effectiveName + "' is invalid");
        }
        String effectiveTag = containerImageConfig.tag.orElse(app.getVersion());
        if (!ImageReference.isValidTag((String)effectiveTag)) {
            throw new IllegalArgumentException("The supplied container-image tag '" + effectiveTag + "' is invalid");
        }
        containerImage.produce((BuildItem)new ContainerImageInfoBuildItem(Optional.ofNullable(registry), containerImageConfig.getEffectiveGroup(), effectiveName, effectiveTag, containerImageConfig.additionalTags.orElse(Collections.emptyList())));
    }

    private void ensureSingleContainerImageExtension(Capabilities capabilities) {
        ContainerImageCapabilitiesUtil.getActiveContainerImageCapability(capabilities);
    }
}

