/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.kafka.spring;

import io.opentracing.Tracer;
import io.opentracing.contrib.kafka.spring.MessageListenerMethodInterceptor;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.MessageListenerContainer;

@Aspect
public class TracingKafkaAspect {
    private final Tracer tracer;

    public TracingKafkaAspect(Tracer tracer) {
        this.tracer = tracer;
    }

    @Pointcut(value="execution(public * org.springframework.kafka.config.KafkaListenerContainerFactory.createListenerContainer(..))")
    private void anyCreateListenerContainer() {
    }

    @Pointcut(value="execution(public * org.springframework.kafka.config.KafkaListenerContainerFactory.createContainer(..))")
    private void anyCreateContainer() {
    }

    @Around(value="anyCreateListenerContainer() || anyCreateContainer()")
    public Object wrapListenerContainerCreation(ProceedingJoinPoint pjp) throws Throwable {
        AbstractMessageListenerContainer container;
        Object someMessageListener;
        MessageListenerContainer listener = (MessageListenerContainer)pjp.proceed();
        if (listener instanceof AbstractMessageListenerContainer && (someMessageListener = (container = (AbstractMessageListenerContainer)listener).getContainerProperties().getMessageListener()) instanceof MessageListener) {
            container.setupMessageListener(this.createProxy(someMessageListener));
        }
        return listener;
    }

    Object createProxy(Object bean) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(true);
        factory.addAdvice((Advice)new MessageListenerMethodInterceptor(this.tracer));
        factory.setTarget(bean);
        return factory.getObject();
    }
}

