/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.statistics.StatisticsGateway;

@NonNullApi
@NonNullFields
public class EhCache2Metrics
extends CacheMeterBinder {
    private final StatisticsGateway stats;

    public EhCache2Metrics(Ehcache cache, Iterable<Tag> tags) {
        super(cache, cache.getName(), tags);
        this.stats = cache.getStatistics();
    }

    public static Ehcache monitor(MeterRegistry registry, Ehcache cache, String ... tags) {
        return EhCache2Metrics.monitor(registry, cache, Tags.of(tags));
    }

    public static Ehcache monitor(MeterRegistry registry, Ehcache cache, Iterable<Tag> tags) {
        new EhCache2Metrics(cache, tags).bindTo(registry);
        return cache;
    }

    @Override
    protected Long size() {
        return this.stats.getSize();
    }

    @Override
    protected long hitCount() {
        return this.stats.cacheHitCount();
    }

    @Override
    protected long missCount() {
        return this.stats.cacheMissCount();
    }

    @Override
    protected Long evictionCount() {
        return this.stats.cacheEvictedCount();
    }

    @Override
    protected long putCount() {
        return this.stats.cachePutCount();
    }

    @Override
    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
        Gauge.builder("cache.remoteSize", this.stats, StatisticsGateway::getRemoteSize).description("The number of entries held remotely in this cache").register(registry);
        FunctionCounter.builder("cache.removals", this.stats, StatisticsGateway::cacheRemoveCount).tags(this.getTagsWithCacheName()).description("Cache removals").register(registry);
        FunctionCounter.builder("cache.puts.added", this.stats, StatisticsGateway::cachePutAddedCount).tags(this.getTagsWithCacheName()).tags("result", "added").description("Cache puts resulting in a new key/value pair").register(registry);
        FunctionCounter.builder("cache.puts.added", this.stats, StatisticsGateway::cachePutAddedCount).tags(this.getTagsWithCacheName()).tags("result", "updated").description("Cache puts resulting in an updated value").register(registry);
        this.missMetrics(registry);
        this.commitTransactionMetrics(registry);
        this.rollbackTransactionMetrics(registry);
        this.recoveryTransactionMetrics(registry);
        Gauge.builder("cache.local.offheap.size", this.stats, StatisticsGateway::getLocalOffHeapSize).tags(this.getTagsWithCacheName()).description("Local off-heap size").baseUnit("bytes").register(registry);
        Gauge.builder("cache.local.heap.size", this.stats, StatisticsGateway::getLocalHeapSizeInBytes).tags(this.getTagsWithCacheName()).description("Local heap size").baseUnit("bytes").register(registry);
        Gauge.builder("cache.local.disk.size", this.stats, StatisticsGateway::getLocalDiskSizeInBytes).tags(this.getTagsWithCacheName()).description("Local disk size").baseUnit("bytes").register(registry);
    }

    private void missMetrics(MeterRegistry registry) {
        FunctionCounter.builder("cache.misses", this.stats, StatisticsGateway::cacheMissExpiredCount).tags(this.getTagsWithCacheName()).tags("reason", "expired").description("The number of times cache lookup methods have not returned a value, due to expiry").register(registry);
        FunctionCounter.builder("cache.misses", this.stats, StatisticsGateway::cacheMissNotFoundCount).tags(this.getTagsWithCacheName()).tags("reason", "notFound").description("The number of times cache lookup methods have not returned a value, because the key was not found").register(registry);
    }

    private void commitTransactionMetrics(MeterRegistry registry) {
        FunctionCounter.builder("cache.xa.commits", this.stats, StatisticsGateway::xaCommitReadOnlyCount).tags(this.getTagsWithCacheName()).tags("result", "readOnly").description("Transaction commits that had a read-only result").register(registry);
        FunctionCounter.builder("cache.xa.commits", this.stats, StatisticsGateway::xaCommitExceptionCount).tags(this.getTagsWithCacheName()).tags("result", "exception").description("Transaction commits that failed").register(registry);
        FunctionCounter.builder("cache.xa.commits", this.stats, StatisticsGateway::xaCommitCommittedCount).tags(this.getTagsWithCacheName()).tags("result", "committed").description("Transaction commits that failed").register(registry);
    }

    private void rollbackTransactionMetrics(MeterRegistry registry) {
        FunctionCounter.builder("cache.xa.rollbacks", this.stats, StatisticsGateway::xaRollbackExceptionCount).tags(this.getTagsWithCacheName()).tags("result", "exception").description("Transaction rollbacks that failed").register(registry);
        FunctionCounter.builder("cache.xa.rollbacks", this.stats, StatisticsGateway::xaRollbackSuccessCount).tags(this.getTagsWithCacheName()).tags("result", "success").description("Transaction rollbacks that failed").register(registry);
    }

    private void recoveryTransactionMetrics(MeterRegistry registry) {
        FunctionCounter.builder("cache.xa.recoveries", this.stats, StatisticsGateway::xaRecoveryNothingCount).tags(this.getTagsWithCacheName()).tags("result", "nothing").description("Recovery transactions that recovered nothing").register(registry);
        FunctionCounter.builder("cache.xa.recoveries", this.stats, StatisticsGateway::xaRecoveryRecoveredCount).tags(this.getTagsWithCacheName()).tags("result", "success").description("Successful recovery transaction").register(registry);
    }
}

