/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.NetworkPublication;
import io.aeron.driver.Sender;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.cmd.AddDestinationCmd;
import io.aeron.driver.cmd.CloseSendChannelEndpointCmd;
import io.aeron.driver.cmd.NewPublicationCmd;
import io.aeron.driver.cmd.RegisterSendChannelEndpointCmd;
import io.aeron.driver.cmd.RemoveDestinationCmd;
import io.aeron.driver.cmd.RemovePublicationCmd;
import io.aeron.driver.cmd.SenderCmd;
import io.aeron.driver.media.SendChannelEndpoint;
import java.net.InetSocketAddress;
import java.util.Queue;
import org.agrona.concurrent.status.AtomicCounter;

public class SenderProxy {
    private final ThreadingMode threadingMode;
    private final Queue<SenderCmd> commandQueue;
    private final AtomicCounter failCount;
    private Sender sender;

    public SenderProxy(ThreadingMode threadingMode, Queue<SenderCmd> commandQueue, AtomicCounter failCount) {
        this.threadingMode = threadingMode;
        this.commandQueue = commandQueue;
        this.failCount = failCount;
    }

    public void sender(Sender sender) {
        this.sender = sender;
    }

    public void registerSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
        if (this.isSharedThread()) {
            this.sender.onRegisterSendChannelEndpoint(channelEndpoint);
        } else {
            this.offer(new RegisterSendChannelEndpointCmd(channelEndpoint));
        }
    }

    public void closeSendChannelEndpoint(SendChannelEndpoint channelEndpoint) {
        if (this.isSharedThread()) {
            this.sender.onCloseSendChannelEndpoint(channelEndpoint);
        } else {
            this.offer(new CloseSendChannelEndpointCmd(channelEndpoint));
        }
    }

    public void removeNetworkPublication(NetworkPublication publication) {
        if (this.isSharedThread()) {
            this.sender.onRemoveNetworkPublication(publication);
        } else {
            this.offer(new RemovePublicationCmd(publication));
        }
    }

    public void newNetworkPublication(NetworkPublication publication) {
        if (this.isSharedThread()) {
            this.sender.onNewNetworkPublication(publication);
        } else {
            this.offer(new NewPublicationCmd(publication));
        }
    }

    public void addDestination(SendChannelEndpoint channelEndpoint, InetSocketAddress address) {
        if (this.isSharedThread()) {
            this.sender.onAddDestination(channelEndpoint, address);
        } else {
            this.offer(new AddDestinationCmd(channelEndpoint, address));
        }
    }

    public void removeDestination(SendChannelEndpoint channelEndpoint, InetSocketAddress address) {
        if (this.isSharedThread()) {
            this.sender.onRemoveDestination(channelEndpoint, address);
        } else {
            this.offer(new RemoveDestinationCmd(channelEndpoint, address));
        }
    }

    private boolean isSharedThread() {
        return this.threadingMode == ThreadingMode.SHARED;
    }

    private void offer(SenderCmd cmd) {
        while (!this.commandQueue.offer(cmd)) {
            this.failCount.orderedIncrement();
            Thread.yield();
        }
    }
}

