/*
 * Decompiled with CFR 0.152.
 */
package com.yomahub.liteflow.builder.el.operator.base;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import com.ql.util.express.exception.QLException;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.enums.ExecuteTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import java.util.Objects;

public class OperatorHelper {
    public static void checkObjectSizeGtZero(Object[] objects) throws QLException {
        if (objects.length == 0) {
            throw new QLException("parameter is empty");
        }
    }

    public static void checkObjectSizeGteTwo(Object[] objects) throws QLException {
        OperatorHelper.checkObjectSizeGtZero(objects);
        if (objects.length < 2) {
            throw new QLException("parameter error");
        }
    }

    public static void checkObjectSizeEqOne(Object[] objects) throws QLException {
        OperatorHelper.checkObjectSizeEq(objects, 1);
    }

    public static void checkObjectSizeEqTwo(Object[] objects) throws QLException {
        OperatorHelper.checkObjectSizeEq(objects, 2);
    }

    public static void checkObjectSizeEqThree(Object[] objects) throws QLException {
        OperatorHelper.checkObjectSizeEq(objects, 3);
    }

    public static void checkObjectSizeEq(Object[] objects, int size) throws QLException {
        OperatorHelper.checkObjectSizeGtZero(objects);
        if (objects.length != size) {
            throw new QLException("parameter error");
        }
    }

    public static void checkObjectSizeEq(Object[] objects, int size1, int size2) throws QLException {
        OperatorHelper.checkObjectSizeGtZero(objects);
        if (objects.length != size1 && objects.length != size2) {
            throw new QLException("parameter error");
        }
    }

    public static <T> T convert(Object object, Class<T> clazz) throws QLException {
        String errorMsg = StrUtil.format((CharSequence)"The parameter must be {} item", (Object[])new Object[]{clazz.getSimpleName()});
        return OperatorHelper.convert(object, clazz, errorMsg);
    }

    public static <T> T convert(Object object, Class<T> clazz, String errorMsg) throws QLException {
        try {
            if (clazz.isAssignableFrom(object.getClass())) {
                if (object instanceof Node) {
                    Node node = (Node)object;
                    return (T)node.copy();
                }
                return (T)object;
            }
        }
        catch (Exception e) {
            throw new QLException("An error occurred while copying an object");
        }
        throw new QLException(errorMsg);
    }

    public static void checkItemNotNull(Object[] objects) throws QLException {
        for (Object object : objects) {
            if (!Objects.isNull(object)) continue;
            throw new QLException("DataNotFoundException");
        }
    }

    public static void checkObjMustBeCommonTypeItem(Object object) throws Exception {
        if (!(object instanceof Executable)) {
            throw new QLException("The parameter must be Executable item.");
        }
        Executable item = (Executable)object;
        if (item.getExecuteType().equals((Object)ExecuteTypeEnum.NODE)) {
            Node node = (Node)item;
            if (!ListUtil.toList((Object[])new NodeTypeEnum[]{NodeTypeEnum.COMMON, NodeTypeEnum.SCRIPT, NodeTypeEnum.FALLBACK}).contains((Object)node.getType())) {
                throw new QLException(StrUtil.format((CharSequence)"The node[{}] must be a common type component", (Object[])new Object[]{node.getId()}));
            }
        }
    }

    public static void checkObjMustBeBooleanTypeItem(Object object) throws Exception {
        if (!(object instanceof Executable)) {
            throw new QLException("The parameter must be Executable item.");
        }
        Executable item = (Executable)object;
        if (item.getExecuteType().equals((Object)ExecuteTypeEnum.NODE)) {
            Node node = (Node)item;
            if (!ListUtil.toList((Object[])new NodeTypeEnum[]{NodeTypeEnum.IF, NodeTypeEnum.IF_SCRIPT, NodeTypeEnum.WHILE, NodeTypeEnum.WHILE_SCRIPT, NodeTypeEnum.BREAK, NodeTypeEnum.BREAK_SCRIPT, NodeTypeEnum.FALLBACK}).contains((Object)node.getType())) {
                throw new QLException(StrUtil.format((CharSequence)"The node[{}] must be boolean type Node.", (Object[])new Object[]{node.getId()}));
            }
        } else if (item.getExecuteType().equals((Object)ExecuteTypeEnum.CONDITION)) {
            Condition condition = (Condition)item;
            if (!ListUtil.toList((Object[])new ConditionTypeEnum[]{ConditionTypeEnum.TYPE_AND_OR_OPT, ConditionTypeEnum.TYPE_NOT_OPT}).contains((Object)condition.getConditionType())) {
                throw new QLException(StrUtil.format((CharSequence)"The condition[{}] must be boolean type Condition.", (Object[])new Object[]{condition.getId()}));
            }
        } else {
            throw new QLException("The parameter error.");
        }
    }

    public static void checkObjMustBeForTypeItem(Object object) throws Exception {
        if (!(object instanceof Executable)) {
            throw new QLException("The parameter must be Executable item.");
        }
        Executable item = (Executable)object;
        if (item.getExecuteType().equals((Object)ExecuteTypeEnum.NODE)) {
            Node node = (Node)item;
            if (!ListUtil.toList((Object[])new NodeTypeEnum[]{NodeTypeEnum.FOR, NodeTypeEnum.FOR_SCRIPT, NodeTypeEnum.FALLBACK}).contains((Object)node.getType())) {
                throw new QLException(StrUtil.format((CharSequence)"The node[{}] must be For type Node.", (Object[])new Object[]{node.getId()}));
            }
        } else {
            throw new QLException("The parameter error.");
        }
    }

    public static void checkObjMustBeIteratorTypeItem(Object object) throws Exception {
        if (!(object instanceof Executable)) {
            throw new QLException("The parameter must be Executable item.");
        }
        Executable item = (Executable)object;
        if (item.getExecuteType().equals((Object)ExecuteTypeEnum.NODE)) {
            Node node = (Node)item;
            if (!ListUtil.toList((Object[])new NodeTypeEnum[]{NodeTypeEnum.ITERATOR, NodeTypeEnum.FALLBACK}).contains((Object)node.getType())) {
                throw new QLException(StrUtil.format((CharSequence)"The node[{}] must be Iterator type Node.", (Object[])new Object[]{node.getId()}));
            }
        } else {
            throw new QLException("The parameter error.");
        }
    }

    public static void checkObjMustBeSwitchTypeItem(Object object) throws Exception {
        if (!(object instanceof Executable)) {
            throw new QLException("The parameter must be Executable item.");
        }
        Executable item = (Executable)object;
        if (item.getExecuteType().equals((Object)ExecuteTypeEnum.NODE)) {
            Node node = (Node)item;
            if (!ListUtil.toList((Object[])new NodeTypeEnum[]{NodeTypeEnum.SWITCH, NodeTypeEnum.SWITCH_SCRIPT, NodeTypeEnum.FALLBACK}).contains((Object)node.getType())) {
                throw new QLException(StrUtil.format((CharSequence)"The node[{}] must be Switch type Node.", (Object[])new Object[]{node.getId()}));
            }
        } else {
            throw new QLException("The parameter error.");
        }
    }
}

