/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.tool.auth;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

public class JwtTool {
    private final JWSSigner signer;
    private final JWSVerifier verifier;

    public JwtTool(String secret) {
        try {
            this.signer = new MACSigner(secret);
            this.verifier = new MACVerifier(secret);
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
    }

    public JwtTool(JWSSigner signer, JWSVerifier verifier) {
        this.signer = signer;
        this.verifier = verifier;
    }

    public String createToken(String subject, Map<String, Object> claims, long ttlMillis) {
        try {
            JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().subject(subject).issueTime(new Date()).expirationTime(new Date(System.currentTimeMillis() + ttlMillis));
            if (claims != null) {
                claims.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)builder).claim(arg_0, arg_1));
            }
            SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.HS256).build(), builder.build());
            signedJWT.sign(this.signer);
            return signedJWT.serialize();
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efaJWT token\u5931\u8d25", e);
        }
    }

    public boolean validateToken(String token) {
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            if (!signedJWT.verify(this.verifier)) {
                return false;
            }
            Date expirationTime = signedJWT.getJWTClaimsSet().getExpirationTime();
            return expirationTime != null && expirationTime.after(new Date());
        }
        catch (Exception e) {
            return false;
        }
    }

    public JWTClaimsSet parseToken(String token) throws ParseException {
        SignedJWT signedJWT = SignedJWT.parse((String)token);
        return signedJWT.getJWTClaimsSet();
    }

    public Object getClaim(String token, String claimName) {
        try {
            JWTClaimsSet claims = this.parseToken(token);
            return claims.getClaim(claimName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getExpirationTime(String token) {
        try {
            JWTClaimsSet claims = this.parseToken(token);
            return claims.getExpirationTime();
        }
        catch (Exception e) {
            return null;
        }
    }
}

