/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.model;

import com.xingyuv.jushauth.enums.AuthResponseStatus;
import java.io.Serializable;

public class AuthResponse<T>
implements Serializable {
    private int code;
    private String msg;
    private T data;

    public boolean ok() {
        return this.code == AuthResponseStatus.SUCCESS.getCode();
    }

    public static <T> AuthResponseBuilder<T> builder() {
        return new AuthResponseBuilder();
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public AuthResponse() {
    }

    public AuthResponse(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static class AuthResponseBuilder<T> {
        private int code;
        private String msg;
        private T data;

        AuthResponseBuilder() {
        }

        public AuthResponseBuilder<T> code(int code) {
            this.code = code;
            return this;
        }

        public AuthResponseBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public AuthResponseBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public AuthResponse<T> build() {
            return new AuthResponse<T>(this.code, this.msg, this.data);
        }

        public String toString() {
            return "AuthResponse.AuthResponseBuilder(code=" + this.code + ", msg=" + this.msg + ", data=" + this.data + ")";
        }
    }
}

