/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.jws;

import com.webauthn4j.data.jws.JWSHeader;
import com.webauthn4j.data.jws.JWSSignatureUtil;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.Base64UrlUtil;
import com.webauthn4j.util.SignatureUtil;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWS<T extends Serializable>
implements Serializable {
    private final transient Logger logger = LoggerFactory.getLogger(JWS.class);
    private final JWSHeader header;
    private final T payload;
    private final byte[] signature;
    private final String headerString;
    private final String payloadString;

    JWS(JWSHeader header, String headerString, T payload, String payloadString, byte[] signature) {
        this.header = header;
        this.payload = payload;
        this.signature = signature;
        this.headerString = headerString;
        this.payloadString = payloadString;
    }

    public JWSHeader getHeader() {
        return this.header;
    }

    public T getPayload() {
        return this.payload;
    }

    public byte[] getSignature() {
        return ArrayUtil.clone((byte[])this.signature);
    }

    public boolean isValidSignature() {
        String signedData = this.headerString + "." + this.payloadString;
        try {
            Signature signatureObj = SignatureUtil.createSignature((String)this.header.getAlg().getJcaName());
            PublicKey publicKey = this.header.getX5c().getEndEntityAttestationCertificate().getCertificate().getPublicKey();
            signatureObj.initVerify(publicKey);
            signatureObj.update(signedData.getBytes());
            byte[] sig = publicKey instanceof ECPublicKey ? JWSSignatureUtil.convertJwsSignatureToDerSignature(this.signature) : this.signature;
            return signatureObj.verify(sig);
        }
        catch (InvalidKeyException | SignatureException e) {
            this.logger.debug("Signature verification failed", (Throwable)e);
            return false;
        }
    }

    public byte[] getBytes() {
        return this.toString().getBytes(StandardCharsets.UTF_8);
    }

    public String toString() {
        return this.headerString + "." + this.payloadString + "." + Base64UrlUtil.encodeToString((byte[])this.signature);
    }
}

