/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.HttpSimpleClient;
import com.taobao.diamond.client.impl.IOUtils;
import com.taobao.diamond.client.impl.TimerService;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SiteIp {
    public static final String SITEIP_URL = "http://jmenv.tbsite.net:8080/siteip";
    static volatile Map<int[], String> ip2siteMap = null;

    public static void main(String[] args) throws Exception {
        String ip = "172.223.1.1";
        System.out.println(SiteIp.getSite(ip));
    }

    public static String getSite(String ip) {
        if (null == ip2siteMap) {
            return null;
        }
        int intip = SiteIp.ip2int(ip);
        for (Map.Entry<int[], String> entry : ip2siteMap.entrySet()) {
            int siteIp = entry.getKey()[0];
            int mask = entry.getKey()[1];
            if ((intip & mask) != (siteIp & mask)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static void getSiteIp() {
        try {
            HttpSimpleClient.HttpResult result = HttpSimpleClient.httpGet(SITEIP_URL, null, null, null, 2000L);
            if (200 == result.code) {
                List<String> lines = IOUtils.readLines(new StringReader(result.content));
                HashMap<int[], String> ip2site = new HashMap<int[], String>();
                for (String line : lines) {
                    if (null == line || line.trim().isEmpty()) continue;
                    line = line.trim();
                    String[] tokens = line.split("=");
                    String site = tokens[1];
                    String[] ipAndMask = tokens[0].split("/");
                    String ip = ipAndMask[0];
                    String bits = ipAndMask[1];
                    int[] arr = new int[]{SiteIp.ip2int(ip), SiteIp.calculateMask(Integer.parseInt(bits))};
                    ip2site.put(arr, site);
                }
                ip2siteMap = ip2site;
            } else {
                DiamondEnv.log.error((Object)("[siteip] failed to get siteip, error code " + result.code));
            }
        }
        catch (IOException e) {
            DiamondEnv.log.debug((Object)("[siteip] exception, " + e.toString()), (Throwable)e);
        }
    }

    private static int ip2int(String ip) {
        String[] tokens = ip.split("\\.");
        int v = 0;
        v |= Integer.parseInt(tokens[0]) << 24;
        v |= Integer.parseInt(tokens[1]) << 16;
        v |= Integer.parseInt(tokens[2]) << 8;
        return v |= Integer.parseInt(tokens[3]);
    }

    private static int calculateMask(int maskBitCount) {
        int v = 0;
        int shiftCount = 32;
        for (int i = 0; i < maskBitCount; ++i) {
            v |= 1 << --shiftCount;
        }
        return v;
    }

    static {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    SiteIp.getSiteIp();
                }
                catch (Exception e) {
                    DiamondEnv.log.error((Object)("unexpected exception, " + e.toString()), (Throwable)e);
                }
            }
        };
        task.run();
        TimerService.scheduleWithFixedDelay(task, 0L, 1L, TimeUnit.HOURS);
    }
}

