/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.DiamondEnvRepo;
import com.taobao.diamond.client.impl.EventDispatcher;
import com.taobao.diamond.client.impl.HttpSimpleClient;
import com.taobao.diamond.client.impl.IOUtils;
import com.taobao.diamond.client.impl.LocalConfigInfoProcessor;
import com.taobao.diamond.client.impl.ServerAddressIterator;
import com.taobao.diamond.client.impl.TimerService;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ServerListManager {
    public static final String ADDRESS_SERVER_URL = "http://jmenv.tbsite.net:8080/diamond-server/diamond";
    public static final String DEFAULT_NAME = "default";
    static final int TIMEOUT = 5000;
    final boolean isFixed;
    boolean isStarted = false;
    volatile List<String> serverUrls = new ArrayList<String>();
    String name;
    private DiamondEnv env = null;

    public ServerListManager() {
        this.isFixed = false;
        this.isStarted = false;
        this.name = DEFAULT_NAME;
    }

    public ServerListManager(List<String> fixed) {
        this.isFixed = true;
        this.isStarted = true;
        this.serverUrls = new ArrayList<String>(fixed);
        this.name = DiamondEnvRepo.getWorkerName(fixed.toArray(new String[fixed.size()]));
    }

    public synchronized void start() {
        if (this.isStarted || this.isFixed) {
            return;
        }
        GetServerListTask getServersTask = new GetServerListTask(ADDRESS_SERVER_URL);
        while (this.serverUrls.isEmpty()) {
            getServersTask.run();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        TimerService.scheduleWithFixedDelay(getServersTask, 0L, 30L, TimeUnit.SECONDS);
        this.isStarted = true;
    }

    Iterator<String> iterator() {
        if (this.serverUrls.isEmpty()) {
            DiamondEnv.log.error((Object)"[serverlist] No server address defined!");
        }
        return new ServerAddressIterator(this.serverUrls);
    }

    private void updateIfChanged(List<String> newList) {
        if (null == newList || newList.isEmpty()) {
            DiamondEnv.log.warn((Object)"apache diamond serverlist is empty!!!");
            return;
        }
        if (((Object)newList).equals(this.serverUrls)) {
            return;
        }
        this.serverUrls = new ArrayList<String>(newList);
        LocalConfigInfoProcessor.saveServerlist(this.name, this.serverUrls);
        if (this.env != null && this.env.agent != null) {
            this.env.agent.reSetCurrentServerIp();
        }
        EventDispatcher.fireEvent(new EventDispatcher.ServerlistChangeEvent());
        DiamondEnv.log.info((Object)("[" + this.toString() + "] updated to " + this.serverUrls));
    }

    static List<String> getApacheServerList(String url) {
        try {
            HttpSimpleClient.HttpResult httpResult = HttpSimpleClient.httpGet(url, null, null, null, 2000L);
            if (200 == httpResult.code) {
                List<String> lines = IOUtils.readLines(new StringReader(httpResult.content));
                ArrayList<String> result = new ArrayList<String>(lines.size());
                for (String line : lines) {
                    if (null == line || line.trim().isEmpty()) continue;
                    result.add(line.trim());
                }
                return result;
            }
            DiamondEnv.log.error((Object)("[serverlist] error code " + httpResult.code));
            return null;
        }
        catch (IOException e) {
            DiamondEnv.log.error((Object)("[serverlist] exception, " + e.toString()), (Throwable)e);
            return null;
        }
    }

    public void initServerList() {
        GetServerListTask getServersTask = new GetServerListTask(ADDRESS_SERVER_URL);
        for (int i = 0; i < 3 && this.serverUrls.isEmpty(); ++i) {
            getServersTask.run();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    String getUrlString() {
        return this.serverUrls.toString();
    }

    public DiamondEnv getEnv() {
        return this.env;
    }

    public void setEnv(DiamondEnv env) {
        this.env = env;
    }

    public String toString() {
        return "ServerManager-" + (this.isFixed ? this.getUrlString() : DEFAULT_NAME);
    }

    class GetServerListTask
    implements Runnable {
        final String url;

        GetServerListTask(String url) {
            this.url = url;
        }

        @Override
        public void run() {
            try {
                ServerListManager.this.updateIfChanged(ServerListManager.getApacheServerList(this.url));
            }
            catch (Exception e) {
                DiamondEnv.log.error((Object)("[serverlist] failed to get serverlist, " + e.toString()), (Throwable)e);
            }
        }
    }
}

