/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.Diamond;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class LocalConfigInfoProcessor {
    public static final String DATAID_SERVER_LIST = "com.taobao.diamond.serverlist";
    public static final LocalConfigInfoProcessor singleton = new LocalConfigInfoProcessor();
    public static final String localFileRootPath = System.getProperty("JM.LOG.PATH", System.getProperty("user.home")) + File.separator + "diamond";
    static final File logRoot;

    public static String getFailover(DiamondEnv env, String dataId, String group) {
        File localPath = LocalConfigInfoProcessor.getFailoverFile(env, dataId, group);
        if (!localPath.exists() || !localPath.isFile()) {
            return null;
        }
        try {
            return LocalConfigInfoProcessor.readFile(localPath);
        }
        catch (IOException ioe) {
            DiamondEnv.log.error((Object)("get failover error, " + localPath + ioe.toString()));
            return null;
        }
    }

    public static String getSnapshot(DiamondEnv env, String dataId, String group) {
        File file = LocalConfigInfoProcessor.getSnapshotFile(env, dataId, group);
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            return LocalConfigInfoProcessor.readFile(file);
        }
        catch (IOException ioe) {
            DiamondEnv.log.error((Object)("get snapshot error, " + file + ", " + ioe.toString()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            String string = IOUtils.toString(is, "GBK");
            return string;
        }
        finally {
            try {
                if (null != is) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void saveSnapshot(DiamondEnv env, String dataId, String group, String config) {
        LocalConfigInfoProcessor.saveSnapshot(env.serverMgr.name, dataId, group, config);
    }

    public static void saveSnapshot(String envName, String dataId, String group, String config) {
        File file = LocalConfigInfoProcessor.getSnapshotFile(envName, dataId, group);
        if (null == config) {
            try {
                IOUtils.delete(file);
            }
            catch (IOException ioe) {
                DiamondEnv.log.error((Object)("delete snapshot error, " + file + ", " + ioe.toString()));
            }
        } else {
            try {
                file.getParentFile().mkdirs();
                IOUtils.writeStringToFile(file, config, "GBK");
            }
            catch (IOException ioe) {
                DiamondEnv.log.error((Object)("save snapshot error, " + file + ", " + ioe.toString()));
            }
        }
    }

    public static void cleanAllSnapshot() {
        try {
            File[] files;
            File rootFile = new File(localFileRootPath);
            for (File file : files = rootFile.listFiles()) {
                if (!file.getName().endsWith("_diamond")) continue;
                IOUtils.cleanDirectory(file);
            }
        }
        catch (IOException ioe) {
            DiamondEnv.log.error((Object)("clean all snapshot error, " + ioe.toString()), (Throwable)ioe);
        }
    }

    public static void cleanEnvSnapshot(String envName) {
        File tmp = new File(localFileRootPath, envName + "_diamond");
        tmp = new File(tmp, "snapshot");
        try {
            IOUtils.cleanDirectory(tmp);
            DiamondEnv.log.info((Object)("success dlelet " + envName + "-snapshot"));
        }
        catch (IOException e) {
            DiamondEnv.log.info((Object)("fail dlelet " + envName + "-snapshot, " + e.toString()));
            e.printStackTrace();
        }
    }

    public static void saveServerlist(DiamondEnv env, List<String> serverUrls) {
        LocalConfigInfoProcessor.saveServerlist(env.serverMgr.name, serverUrls);
    }

    public static void saveServerlist(String envName, List<String> serverUrls) {
        StringBuilder sb = new StringBuilder();
        for (String ip : serverUrls) {
            sb.append(ip).append("\r\n");
        }
        LocalConfigInfoProcessor.saveSnapshot(envName, DATAID_SERVER_LIST, "DEFAULT_GROUP", sb.toString());
    }

    public static List<String> readServerlist(DiamondEnv env) {
        String content = LocalConfigInfoProcessor.getSnapshot(env, DATAID_SERVER_LIST, "DEFAULT_GROUP");
        if (null == content) {
            return null;
        }
        ArrayList<String> serverlist = new ArrayList<String>();
        try {
            BufferedReader is = new BufferedReader(new StringReader(content));
            String line = null;
            while (null != (line = is.readLine())) {
                if ("".equals(line.trim())) continue;
                serverlist.add(line);
            }
            return serverlist;
        }
        catch (IOException ioe) {
            DiamondEnv.log.error((Object)("get serverlist snapshot error, " + ioe.toString()));
            return null;
        }
    }

    public static void main(String[] args) throws IOException {
        Diamond.getConfig("test", "test", 2000L);
    }

    static File getFailoverFile(DiamondEnv env, String dataId, String group) {
        File tmp = new File(localFileRootPath, env.serverMgr.name + "_diamond");
        tmp = new File(tmp, "data");
        tmp = new File(tmp, "config-data");
        return new File(new File(tmp, group), dataId);
    }

    static File getSnapshotFile(DiamondEnv env, String dataId, String group) {
        return LocalConfigInfoProcessor.getSnapshotFile(env.serverMgr.name, dataId, group);
    }

    static File getSnapshotFile(String envName, String dataId, String group) {
        File tmp = new File(localFileRootPath, envName + "_diamond");
        tmp = new File(tmp, "snapshot");
        return new File(new File(tmp, group), dataId);
    }

    public static String getLogFile() {
        return new File(logRoot, "diamond-client.log").getAbsolutePath();
    }

    static {
        File tmp = new File(localFileRootPath, "logs");
        tmp.mkdirs();
        if (!tmp.exists()) {
            throw new RuntimeException("create log directory error: " + tmp);
        }
        logRoot = tmp;
    }
}

