/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.impl.CacheData;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.DiamondEnvRepo;
import com.taobao.diamond.client.impl.HttpSimpleClient;
import com.taobao.diamond.client.impl.IOUtils;
import com.taobao.diamond.client.impl.ServerListManager;
import com.taobao.diamond.client.impl.ServerManager_unitSite;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiamondUnitSite {
    private static ServerListManager serverMgr_default = new ServerListManager();
    private static ServerListManager serverMgr_center = new ServerManager_unitSite("center");
    static Map<String, ServerListManager> unit2serverMgr = new HashMap<String, ServerListManager>();
    public static Map<String, Map<String, CacheData>> mockServerCache = null;

    public static boolean isInCenterUnit() {
        return serverMgr_default.getUrlString().equals(serverMgr_center.getUrlString());
    }

    public static void switchToCenterUnit() {
        DiamondEnvRepo.defaultEnv.initServerManager(serverMgr_center);
    }

    public static void switchToLocalUnit() {
        DiamondEnvRepo.defaultEnv.initServerManager(serverMgr_default);
    }

    public static DiamondEnv getCenterUnitEnv() {
        DiamondEnv env = DiamondEnvRepo.getUnitEnv("center");
        return env;
    }

    public static DiamondEnv getDiamondUnitEnv(String unitName) {
        DiamondEnv env = DiamondEnvRepo.getUnitEnv(unitName);
        return env;
    }

    public static void publishToAllUnit(String dataId, String group, String content) throws IOException {
        for (DiamondEnv env : DiamondUnitSite.getUnitList()) {
            if (env.publishSingle(dataId, group, content)) continue;
            throw new IOException("pub fail to unit " + env + ", " + dataId + ", " + group);
        }
    }

    public static void removeToAllUnit(String dataId, String group) throws IOException {
        for (DiamondEnv env : DiamondUnitSite.getUnitList()) {
            if (env.remove(dataId, group)) continue;
            throw new IOException("rm fail to unit " + env + ", " + dataId + ", " + group);
        }
    }

    public static List<DiamondEnv> getUnitList() throws IOException {
        List<String> unitNameList = null;
        HttpSimpleClient.HttpResult httpResult = HttpSimpleClient.httpGet("http://jmenv.tbsite.net:8080/diamond-server/unit-list?nofix=1", null, null, "GBK", 1000L);
        if (200 != httpResult.code) {
            throw new IOException("http code " + httpResult.code + ", msg: " + httpResult.content);
        }
        unitNameList = IOUtils.readLines(new StringReader(httpResult.content));
        if (!unitNameList.contains("center")) {
            unitNameList.add("center");
        }
        ArrayList<DiamondEnv> envList = new ArrayList<DiamondEnv>(unitNameList.size());
        for (String unitName : unitNameList) {
            DiamondEnv env = DiamondEnvRepo.getUnitEnv(unitName);
            envList.add(env);
        }
        return envList;
    }

    static {
        serverMgr_default.initServerList();
        serverMgr_center.initServerList();
    }
}

