/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.ServerListManager;
import com.taobao.diamond.client.impl.ServerManager_unitSite;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiamondEnvRepo {
    public static final DiamondEnv defaultEnv = new DiamondEnv(new ServerListManager());
    private static final Map<String, DiamondEnv> diamondEnvs = new HashMap<String, DiamondEnv>();

    public static synchronized List<DiamondEnv> allDiamondEnvs() {
        ArrayList<DiamondEnv> envs = new ArrayList<DiamondEnv>(diamondEnvs.values());
        envs.add(defaultEnv);
        return envs;
    }

    public static synchronized DiamondEnv getTargetEnv(String ... serverIps) {
        for (int i = 0; i < serverIps.length; ++i) {
            serverIps[i] = serverIps[i].trim();
            String ip = serverIps[i];
            try {
                InetAddress.getByName(ip);
                continue;
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        String name = DiamondEnvRepo.getWorkerName(serverIps);
        DiamondEnv env = diamondEnvs.get(name);
        if (null == env) {
            env = new DiamondEnv(serverIps);
            diamondEnvs.put(name, env);
        }
        return env;
    }

    protected static synchronized DiamondEnv getUnitEnv(String unitName) {
        DiamondEnv env = diamondEnvs.get(unitName);
        if (null != env) {
            return env;
        }
        env = new DiamondEnv(new ServerManager_unitSite(unitName));
        diamondEnvs.put(unitName, env);
        return env;
    }

    protected static String getWorkerName(String ... serverIps) {
        StringBuilder sb = new StringBuilder("com.taobao.diamond.client.worker-");
        String split = "";
        for (String serverIp : serverIps) {
            sb.append(split);
            sb.append(serverIp);
            split = "-";
        }
        return sb.toString();
    }
}

