/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.diamond.client.impl;

import com.taobao.diamond.client.impl.CacheData;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.HttpSimpleClient;
import com.taobao.diamond.client.impl.LocalConfigInfoProcessor;
import com.taobao.diamond.common.Constants;
import com.taobao.diamond.common.GroupKey;
import com.taobao.diamond.md5.MD5;
import com.taobao.diamond.mockserver.MockServer;
import com.taobao.diamond.utils.ContentUtils;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class ClientWorker {
    final ScheduledExecutorService executor;
    final DiamondEnv env;

    static String getServerConfig(DiamondEnv env, String dataId, String group, long readTimeout) throws IOException {
        if (StringUtils.isBlank((String)group)) {
            group = "DEFAULT_GROUP";
        }
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group, env);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            List<String> params = Arrays.asList("dataId", dataId, "group", group);
            result = env.agent.httpGet("/config.co", null, params, "GBK", readTimeout);
        }
        catch (IOException e) {
            DiamondEnv.log.warn((Object)("[sub-server] get server config exception, dataId=" + dataId + ", group=" + group + ", " + e.toString()));
            throw e;
        }
        switch (result.code) {
            case 200: {
                LocalConfigInfoProcessor.saveSnapshot(env, dataId, group, result.content);
                return result.content;
            }
            case 404: {
                LocalConfigInfoProcessor.saveSnapshot(env, dataId, group, null);
                return null;
            }
            case 409: {
                DiamondEnv.log.warn((Object)"[sub-server-error] data being modified");
                throw new IOException("data being modified");
            }
        }
        DiamondEnv.log.warn((Object)("[sub-server-error] error code " + result.code));
        throw new IOException("http code: " + result.code);
    }

    private void checkLocalConfigInfo() {
        for (CacheData cacheData : this.env.getAllCacheDataSnapshot()) {
            try {
                ClientWorker.checkLocalConfig(this.env, cacheData);
            }
            catch (Exception e) {
                DiamondEnv.log.error((Object)"get local config info error", (Throwable)e);
            }
        }
        ClientWorker.checkListenerMd5(this.env);
    }

    static void checkLocalConfig(DiamondEnv env, CacheData cacheData) {
        String dataId = cacheData.dataId;
        String group = cacheData.group;
        File path = LocalConfigInfoProcessor.getFailoverFile(env, dataId, group);
        if (!cacheData.isUseLocalConfigInfo() && path.exists()) {
            String content = LocalConfigInfoProcessor.getFailover(env, dataId, group);
            String md5 = MD5.getInstance().getMD5String(content);
            cacheData.setUseLocalConfigInfo(true);
            cacheData.setLocalConfigInfoVersion(path.lastModified());
            cacheData.setContent(content);
            DiamondEnv.log.warn((Object)("[failover-change] file created. " + dataId + ", " + group + ", md5=" + md5 + ", content=" + ContentUtils.truncateContent((String)content)));
            return;
        }
        if (cacheData.isUseLocalConfigInfo() && !path.exists()) {
            cacheData.setUseLocalConfigInfo(false);
            DiamondEnv.log.warn((Object)("[failover-change] file deleted. " + dataId + ", " + group));
            return;
        }
        if (cacheData.isUseLocalConfigInfo() && path.exists() && cacheData.getLocalConfigInfoVersion() != path.lastModified()) {
            String content = LocalConfigInfoProcessor.getFailover(env, dataId, group);
            String md5 = MD5.getInstance().getMD5String(content);
            cacheData.setUseLocalConfigInfo(true);
            cacheData.setLocalConfigInfoVersion(path.lastModified());
            cacheData.setContent(content);
            DiamondEnv.log.warn((Object)("[failover-change] file changed. " + dataId + ", " + group + ", md5=" + md5 + ", content=" + ContentUtils.truncateContent((String)content)));
            return;
        }
    }

    public void checkServerConfigInfo() {
        ClientWorker.checkServerConfigInfo(this.env);
    }

    public static void checkServerConfigInfo(DiamondEnv env) {
        for (String groupKey : ClientWorker.checkUpdateDataIds(env)) {
            String dataId = GroupKey.parseKey((String)groupKey)[0];
            String group = GroupKey.parseKey((String)groupKey)[1];
            try {
                String content = ClientWorker.getServerConfig(env, dataId, group, 3000L);
                CacheData cache = env.getCache(dataId, group);
                cache.setContent(content);
                DiamondEnv.log.info((Object)("[data-received] dataId=" + dataId + ", group=" + group + ", md5=" + cache.getMd5() + ", content=" + ContentUtils.truncateContent((String)content)));
            }
            catch (IOException ioe) {
                DiamondEnv.log.warn((Object)ioe.toString(), (Throwable)ioe);
            }
        }
        ClientWorker.checkListenerMd5(env);
    }

    static List<String> checkUpdateDataIds(DiamondEnv env) {
        if (MockServer.isTestMode()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ArrayList<String> updateList = new ArrayList<String>();
            for (CacheData cacheData : env.getAllCacheDataSnapshot()) {
                if (CacheData.getMd5String(MockServer.getConfigInfo(cacheData.dataId, cacheData.group, env)).equals(cacheData.getMd5())) continue;
                updateList.add(GroupKey.getKey((String)cacheData.dataId, (String)cacheData.group));
            }
            return updateList;
        }
        String probeUpdateString = ClientWorker.getProbeUpdateString(env);
        List<String> params = Arrays.asList("Probe-Modify-Request", probeUpdateString);
        long timeout = TimeUnit.SECONDS.toMillis(30L);
        List<String> headers = Arrays.asList("longPullingTimeout", "" + timeout);
        if (StringUtils.isBlank((String)probeUpdateString)) {
            return Collections.emptyList();
        }
        try {
            HttpSimpleClient.HttpResult result = env.agent.httpPost("/config.co", headers, params, "GBK", timeout);
            if (200 == result.code) {
                return ClientWorker.parseUpdateDataIdResponse(result.content);
            }
            DiamondEnv.log.warn((Object)("[check-update] get changed dataId error, HTTP State: " + result.code));
        }
        catch (IOException e) {
            DiamondEnv.log.warn((Object)("[check-update] get changed dataId exception, " + e.toString()));
        }
        return Collections.emptyList();
    }

    private static String getProbeUpdateString(DiamondEnv env) {
        StringBuilder sb = new StringBuilder();
        for (CacheData cacheData : env.getAllCacheDataSnapshot()) {
            if (cacheData.isUseLocalConfigInfo()) continue;
            sb.append(cacheData.dataId).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.group).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.getMd5()).append(Constants.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private static List<String> parseUpdateDataIdResponse(String response) {
        if (StringUtils.isBlank((String)response)) {
            return Collections.emptyList();
        }
        try {
            response = URLDecoder.decode(response, "UTF-8");
        }
        catch (Exception e) {
            DiamondEnv.log.error((Object)"decode modifiedDataIdsString error", (Throwable)e);
        }
        LinkedList<String> updateList = new LinkedList<String>();
        for (String dataIdAndGroup : response.split(Constants.LINE_SEPARATOR)) {
            int idx;
            if (StringUtils.isBlank((String)dataIdAndGroup) || (idx = dataIdAndGroup.indexOf(Constants.WORD_SEPARATOR)) <= 0) continue;
            String dataId = dataIdAndGroup.substring(0, idx);
            String group = dataIdAndGroup.substring(idx + 1);
            updateList.add(GroupKey.getKey((String)dataId, (String)group));
            DiamondEnv.log.info((Object)("[md5-change] " + dataId + ", " + group));
        }
        return updateList;
    }

    static void checkListenerMd5(DiamondEnv env) {
        for (CacheData cacheData : env.getAllCacheDataSnapshot()) {
            cacheData.checkListenerMd5();
        }
    }

    ClientWorker(final DiamondEnv env) {
        this.env = env;
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.taobao.diamond.client.Worker." + env.serverMgr.name);
                t.setDaemon(true);
                return t;
            }
        });
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientWorker.this.checkLocalConfigInfo();
                    ClientWorker.this.checkServerConfigInfo();
                }
                catch (Throwable e) {
                    DiamondEnv.log.error((Object)"[sub-error-rotate] rotate check error", e);
                }
            }
        }, 1L, 1L, TimeUnit.MILLISECONDS);
    }
}

