/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.context;

import com.salesforce.grpc.contrib.context.AmbientContext;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.Iterator;

public class AmbientContextServerInterceptor
implements ServerInterceptor {
    private String headerPrefix;

    public AmbientContextServerInterceptor(String headerPrefix) {
        this.headerPrefix = headerPrefix;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        AmbientContext ctx = (AmbientContext)AmbientContext.DATA_KEY.get();
        ctx = ctx != null ? ctx : new AmbientContext();
        boolean found = false;
        for (String keyName : headers.keys()) {
            Iterable values;
            Metadata.Key key;
            if (!keyName.startsWith(this.headerPrefix)) continue;
            if (keyName.endsWith("-bin")) {
                key = Metadata.Key.of((String)keyName, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
                values = headers.getAll(key);
                if (values == null) continue;
                for (Object value : values) {
                    ctx.put(key, value);
                }
            } else {
                key = Metadata.Key.of((String)keyName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                values = headers.getAll(key);
                if (values == null) continue;
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    Object value;
                    value = (String)iterator.next();
                    ctx.put(key, value);
                }
            }
            found = true;
        }
        if (found) {
            return Contexts.interceptCall((Context)Context.current().withValue(AmbientContext.DATA_KEY, (Object)ctx), call, (Metadata)headers, next);
        }
        return next.startCall(call, headers);
    }
}

