/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.context;

import com.salesforce.grpc.contrib.context.AmbientContext;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;

public class AmbientContextEnforcerClientInterceptor
implements ClientInterceptor {
    private String[] requiredContextKeys = new String[0];

    public AmbientContextEnforcerClientInterceptor() {
    }

    public AmbientContextEnforcerClientInterceptor(String ... requiredContextKeys) {
        this.requiredContextKeys = requiredContextKeys;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (!AmbientContext.isPresent()) {
            throw this.missingContextException();
        }
        for (String requiredKey : this.requiredContextKeys) {
            if (AmbientContext.current().keys().contains(requiredKey)) continue;
            throw this.incompleteContextException(requiredKey);
        }
        return next.newCall(method, callOptions);
    }

    protected RuntimeException missingContextException() {
        return new MissingAmbientContextException("No AmbientContext is attached to the current gRPC Context. Make sure Context is correctly transferred between worker threads using Context.wrap() or Context.currentContextExecutor().");
    }

    protected RuntimeException incompleteContextException(String missingKey) {
        return new MissingAmbientContextException("The AmbientContext is missing a required context key: " + missingKey);
    }

    public static class MissingAmbientContextException
    extends RuntimeException {
        public MissingAmbientContextException(String message) {
            super(message);
        }
    }
}

