/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib;

import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public final class Statuses {
    private Statuses() {
    }

    public static boolean hasStatus(Throwable t) {
        return t instanceof StatusException || t instanceof StatusRuntimeException;
    }

    public static boolean hasStatusCode(Throwable t, Status.Code code) {
        if (!Statuses.hasStatus(t)) {
            return false;
        }
        return Statuses.doWithStatus(t, (Status status, Metadata metadata) -> status.getCode() == code);
    }

    public static void doWithStatus(Throwable t, BiConsumer<Status, Metadata> action) {
        Statuses.doWithStatus(t, (Status status, Metadata metadata) -> {
            action.accept((Status)status, (Metadata)metadata);
            return true;
        });
    }

    public static <T> T doWithStatus(Throwable t, BiFunction<Status, Metadata, T> function) {
        if (t instanceof StatusException) {
            return function.apply(((StatusException)t).getStatus(), ((StatusException)t).getTrailers());
        }
        if (t instanceof StatusRuntimeException) {
            return function.apply(((StatusRuntimeException)t).getStatus(), ((StatusRuntimeException)t).getTrailers());
        }
        throw new IllegalArgumentException("Throwable " + t.getClass().getSimpleName() + " is neither a StatusException nor a StatusRuntimeException");
    }
}

