/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib;

import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.internal.DnsNameResolverProvider;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;

public final class FallbackResolver
extends NameResolver.Factory {
    public static final NameResolverProvider DNS = new DnsNameResolverProvider();
    private final List<NameResolverProvider> providers = new LinkedList<NameResolverProvider>();

    public static FallbackResolver startWith(NameResolverProvider first) {
        Preconditions.checkNotNull((Object)first, (Object)"first");
        return new FallbackResolver(first);
    }

    private FallbackResolver(@Nonnull NameResolverProvider first) {
        this.thenCheck(first);
    }

    public FallbackResolver thenCheck(@Nonnull NameResolverProvider provider) {
        Preconditions.checkNotNull((Object)provider, (Object)"provider");
        this.providers.add(provider);
        return this;
    }

    public NameResolver newNameResolver(URI targetUri, Attributes params) {
        for (NameResolverProvider provider : this.providers) {
            NameResolver resolver = provider.newNameResolver(targetUri, params);
            if (resolver == null) continue;
            return resolver;
        }
        return null;
    }

    public String getDefaultScheme() {
        return this.providers.get(0).getDefaultScheme();
    }
}

