/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims;

import com.redhat.victims.ExecutionContext;
import com.redhat.victims.TextUI;
import com.redhat.victims.VictimsException;
import java.util.HashSet;
import org.apache.maven.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VulnerableArtifactException
extends VictimsException {
    private static final long serialVersionUID = 3584021685052005272L;
    private String infoMessage;
    private String errorMessage;
    private String artifact;
    private String action;
    private HashSet<String> cves;

    public VulnerableArtifactException(Artifact a, String action, HashSet<String> cves) {
        super(String.format("CVE: %s, Artifact: %s", cves, a.getId()));
        this.action = action;
        this.infoMessage = TextUI.fmt("INFO_VULNERABLE_DEPENDENCY", a.getArtifactId(), a.getVersion(), TextUI.join(cves, ", "));
        StringBuilder errMsg = new StringBuilder();
        errMsg.append(TextUI.box(TextUI.fmt("ERR_VULNERABLE_HEADING", new Object[0])));
        errMsg.append(TextUI.fmt("ERR_VULNERABLE_DEPENDENCY", new Object[0]));
        for (String cve : cves) {
            errMsg.append(TextUI.fmt("ERR_VULNERABLE_CVE_URL", cve));
            errMsg.append("\n");
        }
        this.errorMessage = errMsg.toString();
        this.cves = cves;
        this.artifact = a.getId();
    }

    public boolean isFatal(ExecutionContext ctx) {
        return ctx.inFatalMode(this.action);
    }

    public String getId() {
        return this.artifact;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getLogMessage() {
        return this.infoMessage;
    }

    public HashSet<String> getVulnerabilites() {
        return this.cves;
    }
}

