/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims;

import com.redhat.victims.ArtifactStub;
import com.redhat.victims.ExecutionContext;
import com.redhat.victims.VictimsException;
import com.redhat.victims.VictimsRecord;
import com.redhat.victims.VictimsScanner;
import com.redhat.victims.VulnerableArtifactException;
import com.redhat.victims.database.VictimsDBInterface;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Callable;
import org.apache.maven.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VictimsCommand
implements Callable<ArtifactStub> {
    private Artifact artifact;
    private ExecutionContext context;

    public VictimsCommand(ExecutionContext ctx, Artifact a) {
        this.context = ctx;
        this.artifact = a;
    }

    @Override
    public ArtifactStub call() throws VulnerableArtifactException, VictimsException {
        boolean alreadyReported = false;
        this.context.getLog().debug((CharSequence)("[victims-enforcer] scanning: " + this.artifact.toString()));
        VictimsDBInterface db = this.context.getDatabase();
        if (this.context.isEnabled("fingerprint")) {
            ArrayList records = null;
            try {
                File localFile = this.artifact.getFile();
                if (localFile != null) {
                    records = VictimsScanner.getRecords((String)localFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new VictimsException(e.getMessage(), (Throwable)e);
            }
            if (records != null) {
                for (VictimsRecord vr : records) {
                    HashSet cves = db.getVulnerabilities(vr);
                    if (cves.isEmpty()) continue;
                    throw new VulnerableArtifactException(this.artifact, "fingerprint", cves);
                }
            }
        }
        if (!alreadyReported && this.context.isEnabled("metadata")) {
            HashMap<String, String> gav = new HashMap<String, String>();
            gav.put("groupId", this.artifact.getGroupId());
            gav.put("artifactId", this.artifact.getArtifactId());
            gav.put("version", this.artifact.getVersion());
            HashSet cves = db.getVulnerabilities(gav);
            if (!cves.isEmpty()) {
                throw new VulnerableArtifactException(this.artifact, "metadata", cves);
            }
        }
        return new ArtifactStub(this.artifact);
    }
}

