/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims;

import com.redhat.victims.TextUI;
import com.redhat.victims.VictimsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public final class Settings {
    public static final String MODE_WARNING = "warning";
    public static final String MODE_FATAL = "fatal";
    public static final String MODE_DISABLED = "disabled";
    public static final String UPDATES_DISABLED = "offline";
    public static final String UPDATES_DAILY = "daily";
    public static final String UPDATES_WEEKLY = "weekly";
    public static final String UPDATES_AUTO = "auto";
    public static final String UPDATES_OVERRIDE = "victims.skip.update";
    public static final String METADATA = "metadata";
    public static final String FINGERPRINT = "fingerprint";
    public static final String UPDATE_DATABASE = "updates";
    public static final Map<String, String> defaults;
    private Map<String, String> settings;
    private Validator[] required = new Validator[]{new Validator(){

        public void validate() throws VictimsException {
            ArrayList<String> modes = new ArrayList<String>();
            modes.add(Settings.MODE_FATAL);
            modes.add(Settings.MODE_WARNING);
            modes.add(Settings.MODE_DISABLED);
            ArrayList<String> modeSettings = new ArrayList<String>();
            modeSettings.add(Settings.METADATA);
            modeSettings.add(Settings.FINGERPRINT);
            for (String item : modeSettings) {
                String value = (String)Settings.this.settings.get(item);
                if (value == null) {
                    throw new VictimsException(TextUI.fmt("ERR_SETTING_MISSING", item));
                }
                if (modes.contains(value)) continue;
                String err = TextUI.fmt("ERR_INVALID_MODE", value, item, ((Object)modes).toString());
                throw new VictimsException(err);
            }
        }
    }};

    public Settings() {
        this.settings = new HashMap<String, String>();
    }

    public void set(String k, String v) {
        this.settings.put(k, v);
    }

    public String get(String k) {
        return this.settings.get(k);
    }

    public void show(Log log) {
        StringBuilder info = new StringBuilder();
        info.append(TextUI.box(TextUI.fmt("INFO_SETTINGS_HEADING", new Object[0])));
        for (Map.Entry<String, String> kv : this.settings.entrySet()) {
            info.append(String.format("%-12s = %s\n", kv.getKey(), kv.getValue()));
        }
        log.info((CharSequence)info.toString());
    }

    public void validate() throws VictimsException {
        for (Validator v : this.required) {
            v.validate();
        }
    }

    static {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put(METADATA, MODE_WARNING);
        mappings.put(FINGERPRINT, MODE_FATAL);
        mappings.put(UPDATE_DATABASE, UPDATES_AUTO);
        defaults = Collections.unmodifiableMap(mappings);
    }

    private static interface Validator {
        public void validate() throws VictimsException;
    }
}

