/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.TreeWalkerAuditEvent;
import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SuppressWithNearbyCommentFilter
extends AutomaticBean
implements TreeWalkerFilter {
    private static final String DEFAULT_COMMENT_FORMAT = "SUPPRESS CHECKSTYLE (\\w+)";
    private static final String DEFAULT_CHECK_FORMAT = ".*";
    private static final String DEFAULT_INFLUENCE_FORMAT = "0";
    private final List<Tag> tags = new ArrayList<Tag>();
    private boolean checkC = true;
    private boolean checkCPP = true;
    private Pattern commentFormat = Pattern.compile("SUPPRESS CHECKSTYLE (\\w+)");
    private String checkFormat = ".*";
    private String messageFormat;
    private String influenceFormat = "0";
    private WeakReference<FileContents> fileContentsReference = new WeakReference<Object>(null);

    public final void setCommentFormat(Pattern pattern) {
        this.commentFormat = pattern;
    }

    private FileContents getFileContents() {
        return (FileContents)this.fileContentsReference.get();
    }

    public void setFileContents(FileContents fileContents) {
        this.fileContentsReference = new WeakReference<FileContents>(fileContents);
    }

    public final void setCheckFormat(String format) {
        this.checkFormat = format;
    }

    public void setMessageFormat(String format) {
        this.messageFormat = format;
    }

    public final void setInfluenceFormat(String format) {
        this.influenceFormat = format;
    }

    public void setCheckCPP(boolean checkCpp) {
        this.checkCPP = checkCpp;
    }

    public void setCheckC(boolean checkC) {
        this.checkC = checkC;
    }

    @Override
    protected void finishLocalSetup() {
    }

    @Override
    public boolean accept(TreeWalkerAuditEvent event) {
        boolean accepted = true;
        if (event.getLocalizedMessage() != null) {
            FileContents currentContents = event.getFileContents();
            if (this.getFileContents() != currentContents) {
                this.setFileContents(currentContents);
                this.tagSuppressions();
            }
            if (this.matchesTag(event)) {
                accepted = false;
            }
        }
        return accepted;
    }

    private boolean matchesTag(TreeWalkerAuditEvent event) {
        boolean result = false;
        for (Tag tag : this.tags) {
            if (!tag.isMatch(event)) continue;
            result = true;
            break;
        }
        return result;
    }

    private void tagSuppressions() {
        this.tags.clear();
        FileContents contents = this.getFileContents();
        if (this.checkCPP) {
            this.tagSuppressions(contents.getSingleLineComments().values());
        }
        if (this.checkC) {
            Collection<List<TextBlock>> cComments = contents.getBlockComments().values();
            cComments.forEach(this::tagSuppressions);
        }
    }

    private void tagSuppressions(Collection<TextBlock> comments) {
        for (TextBlock comment : comments) {
            int startLineNo = comment.getStartLineNo();
            String[] text = comment.getText();
            this.tagCommentLine(text[0], startLineNo);
            for (int i = 1; i < text.length; ++i) {
                this.tagCommentLine(text[i], startLineNo + i);
            }
        }
    }

    private void tagCommentLine(String text, int line) {
        Matcher matcher = this.commentFormat.matcher(text);
        if (matcher.find()) {
            this.addTag(matcher.group(0), line);
        }
    }

    private void addTag(String text, int line) {
        Tag tag = new Tag(text, line, this);
        this.tags.add(tag);
    }

    public static class Tag {
        private final String text;
        private final int firstLine;
        private final int lastLine;
        private final Pattern tagCheckRegexp;
        private final Pattern tagMessageRegexp;

        public Tag(String text, int line, SuppressWithNearbyCommentFilter filter) {
            this.text = text;
            String format = "";
            try {
                int influence;
                format = CommonUtils.fillTemplateWithStringsByRegexp(filter.checkFormat, text, filter.commentFormat);
                this.tagCheckRegexp = Pattern.compile(format);
                if (filter.messageFormat == null) {
                    this.tagMessageRegexp = null;
                } else {
                    format = CommonUtils.fillTemplateWithStringsByRegexp(filter.messageFormat, text, filter.commentFormat);
                    this.tagMessageRegexp = Pattern.compile(format);
                }
                format = CommonUtils.fillTemplateWithStringsByRegexp(filter.influenceFormat, text, filter.commentFormat);
                if (CommonUtils.startsWithChar(format, '+')) {
                    format = format.substring(1);
                }
                if ((influence = Tag.parseInfluence(format, filter.influenceFormat, text)) >= 1) {
                    this.firstLine = line;
                    this.lastLine = line + influence;
                } else {
                    this.firstLine = line + influence;
                    this.lastLine = line;
                }
            }
            catch (PatternSyntaxException ex) {
                throw new IllegalArgumentException("unable to parse expanded comment " + format, ex);
            }
        }

        private static int parseInfluence(String format, String influenceFormat, String text) {
            try {
                return Integer.parseInt(format);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("unable to parse influence from '" + text + "' using " + influenceFormat, ex);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Tag tag = (Tag)other;
            return Objects.equals(this.firstLine, tag.firstLine) && Objects.equals(this.lastLine, tag.lastLine) && Objects.equals(this.text, tag.text) && Objects.equals(this.tagCheckRegexp, tag.tagCheckRegexp) && Objects.equals(this.tagMessageRegexp, tag.tagMessageRegexp);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.firstLine, this.lastLine, this.tagCheckRegexp, this.tagMessageRegexp);
        }

        public boolean isMatch(TreeWalkerAuditEvent event) {
            int line = event.getLine();
            boolean match = false;
            if (line >= this.firstLine && line <= this.lastLine) {
                Matcher tagMatcher = this.tagCheckRegexp.matcher(event.getSourceName());
                if (tagMatcher.find()) {
                    match = true;
                } else if (this.tagMessageRegexp == null) {
                    if (event.getModuleId() != null) {
                        Matcher idMatcher = this.tagCheckRegexp.matcher(event.getModuleId());
                        match = idMatcher.find();
                    }
                } else {
                    Matcher messageMatcher = this.tagMessageRegexp.matcher(event.getMessage());
                    match = messageMatcher.find();
                }
            }
            return match;
        }

        public String toString() {
            return "Tag[text='" + this.text + '\'' + ", firstLine=" + this.firstLine + ", lastLine=" + this.lastLine + ", tagCheckRegexp=" + this.tagCheckRegexp + ", tagMessageRegexp=" + this.tagMessageRegexp + ']';
        }
    }
}

