/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;

@StatelessCheck
public class PackageAnnotationCheck
extends AbstractCheck {
    public static final String MSG_KEY = "annotation.package.location";

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{16};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean containsAnnotation = AnnotationUtility.containsAnnotation(ast);
        boolean inPackageInfo = this.getFileContents().inPackageInfo();
        if (containsAnnotation && !inPackageInfo) {
            this.log(ast.getLine(), MSG_KEY, new Object[0]);
        }
    }
}

