/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Flushables;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

final class PropertyCacheFile {
    public static final String CONFIG_HASH_KEY = "configuration*?";
    public static final String EXTERNAL_RESOURCE_KEY_PREFIX = "module-resource*?:";
    private final Properties details = new Properties();
    private final Configuration config;
    private final String fileName;
    private String configHash;

    PropertyCacheFile(Configuration config, String fileName) {
        if (config == null) {
            throw new IllegalArgumentException("config can not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can not be null");
        }
        this.config = config;
        this.fileName = fileName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load() throws IOException {
        this.configHash = PropertyCacheFile.getHashCodeBasedOnObjectContent(this.config);
        File file = new File(this.fileName);
        if (file.exists()) {
            try (InputStream inStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                this.details.load(inStream);
                String cachedConfigHash = this.details.getProperty(CONFIG_HASH_KEY);
                if (this.configHash.equals(cachedConfigHash)) return;
                this.reset();
                return;
            }
        } else {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist() throws IOException {
        Path path = Paths.get(this.fileName, new String[0]);
        Path directory = path.getParent();
        if (directory != null) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        OutputStream out = null;
        try {
            out = Files.newOutputStream(path, new OpenOption[0]);
            this.details.store(out, null);
        }
        catch (Throwable throwable) {
            PropertyCacheFile.flushAndCloseOutStream(out);
            throw throwable;
        }
        PropertyCacheFile.flushAndCloseOutStream(out);
    }

    public void reset() {
        this.details.clear();
        this.details.setProperty(CONFIG_HASH_KEY, this.configHash);
    }

    private static void flushAndCloseOutStream(OutputStream stream) throws IOException {
        if (stream != null) {
            Flushables.flush((Flushable)stream, (boolean)false);
        }
        Closeables.close((Closeable)stream, (boolean)false);
    }

    public boolean isInCache(String uncheckedFileName, long timestamp) {
        String lastChecked = this.details.getProperty(uncheckedFileName);
        return Objects.equals(lastChecked, Long.toString(timestamp));
    }

    public void put(String checkedFileName, long timestamp) {
        this.details.setProperty(checkedFileName, Long.toString(timestamp));
    }

    public String get(String name) {
        return this.details.getProperty(name);
    }

    public void remove(String checkedFileName) {
        this.details.remove(checkedFileName);
    }

    private static String getHashCodeBasedOnObjectContent(Serializable object) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PropertyCacheFile.serialize(object, outputStream);
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(outputStream.toByteArray());
            return BaseEncoding.base16().upperCase().encode(digest.digest());
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Unable to calculate hashcode.", ex);
        }
    }

    private static void serialize(Serializable object, OutputStream outputStream) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(outputStream);
        try {
            oos.writeObject(object);
        }
        finally {
            PropertyCacheFile.flushAndCloseOutStream(oos);
        }
    }

    public void putExternalResources(Set<String> locations) {
        Set<ExternalResource> resources = PropertyCacheFile.loadExternalResources(locations);
        if (this.areExternalResourcesChanged(resources)) {
            this.reset();
            this.fillCacheWithExternalResources(resources);
        }
    }

    private static Set<ExternalResource> loadExternalResources(Set<String> resourceLocations) {
        HashSet<ExternalResource> resources = new HashSet<ExternalResource>();
        for (String location : resourceLocations) {
            String contentHashSum;
            try {
                byte[] content = PropertyCacheFile.loadExternalResource(location);
                contentHashSum = PropertyCacheFile.getHashCodeBasedOnObjectContent((Serializable)content);
                resources.add(new ExternalResource(EXTERNAL_RESOURCE_KEY_PREFIX + location, contentHashSum));
            }
            catch (CheckstyleException ex) {
                contentHashSum = PropertyCacheFile.getHashCodeBasedOnObjectContent(ex);
                resources.add(new ExternalResource(EXTERNAL_RESOURCE_KEY_PREFIX + location, contentHashSum));
            }
        }
        return resources;
    }

    private static byte[] loadExternalResource(String location) throws CheckstyleException {
        byte[] content;
        URI uri = CommonUtil.getUriByFilename(location);
        try {
            content = ByteStreams.toByteArray((InputStream)new BufferedInputStream(uri.toURL().openStream()));
        }
        catch (IOException ex) {
            throw new CheckstyleException("Unable to load external resource file " + location, ex);
        }
        return content;
    }

    private boolean areExternalResourcesChanged(Set<ExternalResource> resources) {
        return resources.stream().anyMatch(resource -> {
            boolean changed = false;
            if (this.isResourceLocationInCache(((ExternalResource)resource).location)) {
                String contentHashSum = ((ExternalResource)resource).contentHashSum;
                String cachedHashSum = this.details.getProperty(((ExternalResource)resource).location);
                if (!cachedHashSum.equals(contentHashSum)) {
                    changed = true;
                }
            } else {
                changed = true;
            }
            return changed;
        });
    }

    private void fillCacheWithExternalResources(Set<ExternalResource> externalResources) {
        externalResources.forEach(resource -> this.details.setProperty(((ExternalResource)resource).location, ((ExternalResource)resource).contentHashSum));
    }

    private boolean isResourceLocationInCache(String location) {
        String cachedHashSum = this.details.getProperty(location);
        return cachedHashSum != null;
    }

    private static class ExternalResource {
        private final String location;
        private final String contentHashSum;

        ExternalResource(String location, String contentHashSum) {
            this.location = location;
            this.contentHashSum = contentHashSum;
        }
    }
}

