/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.latexsupport;

import com.openhtmltopdf.extend.FSDOMMutator;
import com.openhtmltopdf.latexsupport.DOMConverter;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.ac.ed.ph.snuggletex.utilities.CSSUtilities;

public class LaTeXDOMMutator
implements FSDOMMutator {
    public static final LaTeXDOMMutator INSTANCE = new LaTeXDOMMutator();
    private final DOMConverter converter = new DOMConverter();

    private LaTeXDOMMutator() {
    }

    public void mutateDocument(Document document) {
        try {
            NodeList latexNodes = document.getElementsByTagName("latex");
            for (int i = 0; i < latexNodes.getLength(); ++i) {
                this.converter.convert((Element)latexNodes.item(i));
            }
            if (latexNodes.getLength() != 0) {
                String defaultCSS = CSSUtilities.writeDefaultStylesheet();
                NodeList list = document.getElementsByTagName("head");
                if (list.getLength() == 0) {
                    list = document.getElementsByTagName("body");
                }
                if (list.getLength() > 0) {
                    Element style = document.createElement("style");
                    style.setTextContent(defaultCSS);
                    style.setAttribute("type", "text/css");
                    list.item(0).insertBefore(style, list.item(0).getFirstChild());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

