/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.analyzer.writer;

import com.lazerycode.jmeter.analyzer.parser.AggregatedResponses;
import com.lazerycode.jmeter.analyzer.statistics.Samples;
import com.lazerycode.jmeter.analyzer.util.FileUtil;
import com.lazerycode.jmeter.analyzer.writer.TextWriterBase;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public abstract class DetailsWriterBase
extends TextWriterBase {
    @Override
    public void write(Map<String, AggregatedResponses> testResults) throws IOException, TemplateException {
        for (Map.Entry<String, AggregatedResponses> entry : testResults.entrySet()) {
            String name = entry.getKey();
            AggregatedResponses aggregatedResponses = entry.getValue();
            this.write(aggregatedResponses, name);
        }
    }

    protected abstract String getDurationsSuffix();

    protected abstract String getSizesSuffix();

    private void write(AggregatedResponses aggregatedResponses, String name) throws IOException, TemplateException {
        String durationsFilename = FileUtil.urlEncode(name) + this.getDurationsSuffix();
        Map<String, Samples> data = aggregatedResponses.getDurationByUri();
        this.write(durationsFilename, data);
        durationsFilename = FileUtil.urlEncode(name) + this.getSizesSuffix();
        data = aggregatedResponses.getSizeByUri();
        this.write(durationsFilename, data);
    }

    private void write(String name, Map<String, Samples> data) throws IOException, TemplateException {
        Writer w = this.getWriter(this.getFile(name));
        this.renderText(data, this.getRootTemplate(), w);
        w.flush();
        w.close();
    }
}

