/*
 * Decompiled with CFR 0.152.
 */
package com.lazerycode.jmeter.analyzer.statistics;

import com.lazerycode.jmeter.analyzer.statistics.ValueCount;
import com.lazerycode.jmeter.analyzer.statistics.ValueCountComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Quantile {
    private static final int QUANTILE_MAX = 10000;
    private List<ValueCount> counts;
    private int q;
    private long totalCount;

    protected Quantile(int q, Collection<ValueCount> counts) {
        if (q < 2 || q > 10000) {
            throw new IllegalArgumentException(q + " is not a valid q value to create q-quantiles");
        }
        ArrayList<ValueCount> sorted = new ArrayList<ValueCount>(counts);
        Collections.sort(sorted, new ValueCountComparator());
        this.q = q;
        this.counts = sorted;
        for (ValueCount count : sorted) {
            this.totalCount += count.getCount();
        }
    }

    public long getQuantile(int k) {
        if (k <= 0 || k > this.q) {
            throw new IllegalArgumentException("k must be a positive integer less than " + this.q);
        }
        int i = 0;
        long n = this.totalCount * (long)k / (long)this.q;
        long v = 0L;
        for (ValueCount count : this.counts) {
            if ((long)i >= n) {
                return v;
            }
            v = count.getValue();
            i = (int)((long)i + count.getCount());
        }
        return v;
    }

    public int getGrade() {
        return this.q;
    }
}

