/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.domain;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class ScraperTargetRequest {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type = TypeEnum.PROMETHEUS;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_ORG_I_D = "orgID";
    @SerializedName(value="orgID")
    private String orgID;
    public static final String SERIALIZED_NAME_BUCKET_I_D = "bucketID";
    @SerializedName(value="bucketID")
    private String bucketID;
    public static final String SERIALIZED_NAME_ALLOW_INSECURE = "allowInsecure";
    @SerializedName(value="allowInsecure")
    private Boolean allowInsecure = false;

    public ScraperTargetRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the scraper target.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The type of the metrics to be parsed.")
    public TypeEnum getType() {
        return this.type;
    }

    public ScraperTargetRequest url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="http://localhost:9090/metrics", value="The URL of the metrics endpoint.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ScraperTargetRequest orgID(String orgID) {
        this.orgID = orgID;
        return this;
    }

    @ApiModelProperty(value="The organization ID.")
    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    public ScraperTargetRequest bucketID(String bucketID) {
        this.bucketID = bucketID;
        return this;
    }

    @ApiModelProperty(value="The ID of the bucket to write to.")
    public String getBucketID() {
        return this.bucketID;
    }

    public void setBucketID(String bucketID) {
        this.bucketID = bucketID;
    }

    public ScraperTargetRequest allowInsecure(Boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
        return this;
    }

    @ApiModelProperty(value="Skip TLS verification on endpoint.")
    public Boolean getAllowInsecure() {
        return this.allowInsecure;
    }

    public void setAllowInsecure(Boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScraperTargetRequest scraperTargetRequest = (ScraperTargetRequest)o;
        return Objects.equals(this.name, scraperTargetRequest.name) && Objects.equals((Object)this.type, (Object)scraperTargetRequest.type) && Objects.equals(this.url, scraperTargetRequest.url) && Objects.equals(this.orgID, scraperTargetRequest.orgID) && Objects.equals(this.bucketID, scraperTargetRequest.bucketID) && Objects.equals(this.allowInsecure, scraperTargetRequest.allowInsecure);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.url, this.orgID, this.bucketID, this.allowInsecure});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScraperTargetRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    orgID: ").append(this.toIndentedString(this.orgID)).append("\n");
        sb.append("    bucketID: ").append(this.toIndentedString(this.bucketID)).append("\n");
        sb.append("    allowInsecure: ").append(this.toIndentedString(this.allowInsecure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        PROMETHEUS("prometheus");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

