/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generatePdqXml;

import com.ibm.db2.cmx.runtime.internal.db.LiteralsInfo;
import com.ibm.db2.cmx.runtime.internal.db.SqlStatementKey;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlCaptureStatistics;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementDescriptor;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.PDQXmlStatementForGeneratePureQueryXml;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.SQLFile;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.util.GregorianCalendar;
import java.util.TreeSet;

public class SQLStatementInInputSQLFile {
    public final String inputSqlFilePath_;
    public final int sqlNumber_;
    public final int lineNumberInFile_;
    public final SqlStatementKey sqlStatementKey_;
    public final String uniqueId_;
    public final PDQXmlStatementForGeneratePureQueryXml statement_;
    public final PDQXmlStatementDescriptor statementDescriptor_;
    private LiteralsInfo literalsInfo_ = null;
    private boolean isSqlLiteralSubstituted_ = false;
    private String currentSchemaInInputFile_ = null;

    SQLStatementInInputSQLFile(String string, int n2, PDQXmlStatementForGeneratePureQueryXml pDQXmlStatementForGeneratePureQueryXml, PDQXmlStatementDescriptor pDQXmlStatementDescriptor) {
        this.inputSqlFilePath_ = string;
        this.sqlNumber_ = n2;
        this.statement_ = pDQXmlStatementForGeneratePureQueryXml;
        this.uniqueId_ = this.statement_.getID();
        this.statementDescriptor_ = pDQXmlStatementDescriptor;
        this.sqlStatementKey_ = SqlStatementKey.generateStmtKey(this.statementDescriptor_);
        this.lineNumberInFile_ = this.statementDescriptor_.getLineNumber();
    }

    String getLogMessageForSQL(SqlStatementKey sqlStatementKey) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The SQL statement that was specified starting on line ");
        stringBuilder.append(this.lineNumberInFile_);
        stringBuilder.append(" of the input SQL file is \"");
        stringBuilder.append(this.sqlStatementKey_.sqlStr_);
        stringBuilder.append("\".  The attributes for the SQL statement are: ");
        stringBuilder.append(this.sqlStatementKey_.getStatementAttributesFormatted(false, null, null));
        if (null != sqlStatementKey && !sqlStatementKey.equals(this.sqlStatementKey_)) {
            stringBuilder.append("  The SQL statement after performing literal substitution is \"");
            stringBuilder.append(sqlStatementKey.sqlStr_);
            stringBuilder.append("\".");
        }
        return stringBuilder.toString();
    }

    public String getSQLLocationDescription() {
        return Messages.getText("MSG_LOCATION_IN_USER_INPUTSQL_FILE_FOR_GENERATEPUREQUERYXML", PossibleArgs.INPUT_SQL.externalOptionName(), this.sqlNumber_, this.lineNumberInFile_, this.inputSqlFilePath_);
    }

    public void setLiteralsInfo(LiteralsInfo literalsInfo) {
        this.literalsInfo_ = literalsInfo;
    }

    public LiteralsInfo getLiteralsInfo() {
        return this.literalsInfo_;
    }

    public void setIsSqlLiteralSubstituted(boolean bl2) {
        this.isSqlLiteralSubstituted_ = bl2;
    }

    public boolean isSqlLiteralSubstituted() {
        return this.isSqlLiteralSubstituted_;
    }

    private String getMessageStatingCurrentSchemaInInputFile() {
        if (null == this.currentSchemaInInputFile_) {
            return Messages.getText("MSG_SR_VALUE_OF_STATEMENT_NOT_SPECIFIED", this.sqlNumber_);
        }
        return Messages.getText("MSG_SR_VALUE_OF_STATEMENT", this.sqlNumber_, this.currentSchemaInInputFile_);
    }

    public void setCurrentSchemaInInputFile(String string) {
        this.currentSchemaInInputFile_ = string;
    }

    String copyInformationFromDuplicateSQL(String string, SQLStatementInInputSQLFile sQLStatementInInputSQLFile, TreeSet<Integer> treeSet) {
        TreeSet<Integer> treeSet2;
        String string2;
        StringBuilder stringBuilder = null;
        String string3 = null != this.currentSchemaInInputFile_ ? this.currentSchemaInInputFile_ : string;
        String string4 = string2 = null != sQLStatementInInputSQLFile.currentSchemaInInputFile_ ? sQLStatementInInputSQLFile.currentSchemaInInputFile_ : string;
        if (!string3.equals(string2)) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(Messages.getText("MSG_SR_VALUE_CONFLICTING_FOR_TWO_SQL_STATEMENTS", "CURRENT SCHEMA"));
            stringBuilder.append("  ").append(this.getMessageStatingCurrentSchemaInInputFile());
            stringBuilder.append("  ").append(sQLStatementInInputSQLFile.getMessageStatingCurrentSchemaInInputFile());
            stringBuilder.append("  ").append(Messages.getText("MSG_SR_VALUE_USED_FOR_METADATA", "CURRENT SCHEMA", string3));
        }
        if (null != (treeSet2 = sQLStatementInInputSQLFile.statementDescriptor_.getSpecialRegisterValuesSets())) {
            this.statementDescriptor_.addAllSpecialRegisterValuesSets(sQLStatementInInputSQLFile.statementDescriptor_);
            treeSet.addAll(treeSet2);
        }
        PDQXmlCaptureStatistics pDQXmlCaptureStatistics = SQLFile.getCaptureStatistics(this.statement_);
        PDQXmlCaptureStatistics pDQXmlCaptureStatistics2 = SQLFile.getCaptureStatistics(sQLStatementInInputSQLFile.statement_);
        if (pDQXmlCaptureStatistics2.isExecutionCountSet() || pDQXmlCaptureStatistics.isExecutionCountSet()) {
            int n2 = Integer.MAX_VALUE - pDQXmlCaptureStatistics.getExecutionCount() < pDQXmlCaptureStatistics2.getExecutionCount() ? Integer.MAX_VALUE : pDQXmlCaptureStatistics.getExecutionCount() + pDQXmlCaptureStatistics2.getExecutionCount();
            pDQXmlCaptureStatistics.setExecutionCount(n2);
        }
        GregorianCalendar[] gregorianCalendarArray = new GregorianCalendar[4];
        GregorianCalendar gregorianCalendar = gregorianCalendarArray[0] = pDQXmlCaptureStatistics.getFirstExecutionTime();
        gregorianCalendarArray[1] = pDQXmlCaptureStatistics2.getFirstExecutionTime();
        GregorianCalendar gregorianCalendar2 = gregorianCalendarArray[2] = pDQXmlCaptureStatistics.getLastExecutionTime();
        gregorianCalendarArray[3] = pDQXmlCaptureStatistics2.getLastExecutionTime();
        for (GregorianCalendar gregorianCalendar3 : gregorianCalendarArray) {
            if (null == gregorianCalendar || null != gregorianCalendar3 && 0 < gregorianCalendar.compareTo(gregorianCalendar3)) {
                gregorianCalendar = gregorianCalendar3;
            }
            if (null != gregorianCalendar2 && (null == gregorianCalendar3 || 0 <= gregorianCalendar2.compareTo(gregorianCalendar3))) continue;
            gregorianCalendar2 = gregorianCalendar3;
        }
        if (null != gregorianCalendar) {
            pDQXmlCaptureStatistics.setFirstExecutionTime(gregorianCalendar);
        }
        if (null != gregorianCalendar2) {
            pDQXmlCaptureStatistics.setLastExecutionTime(gregorianCalendar2);
        }
        Long l8 = pDQXmlCaptureStatistics.getMaxStmtExecutionTimeInMicroseconds();
        Long l9 = pDQXmlCaptureStatistics2.getMaxStmtExecutionTimeInMicroseconds();
        if (null != l9) {
            if (null == l8) {
                pDQXmlCaptureStatistics.setStmtMaxExecutionTimeInMicroseconds(l9);
            } else {
                long l10 = Math.max(l8, l9);
                pDQXmlCaptureStatistics.setStmtMaxExecutionTimeInMicroseconds(l10);
            }
        }
        return null != stringBuilder ? stringBuilder.toString() : null;
    }
}

