/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.inject.internal.util.StackTraceElements;
import com.google.inject.spi.Dependency;
import java.lang.reflect.Member;

public final class DependencyAndSource {
    private final Dependency<?> dependency;
    private final Object source;

    public DependencyAndSource(Dependency<?> dependency, Object source) {
        this.dependency = dependency;
        this.source = source;
    }

    public Dependency<?> getDependency() {
        return this.dependency;
    }

    public String getBindingSource() {
        if (this.source instanceof Class) {
            return StackTraceElements.forType((Class)this.source).toString();
        }
        if (this.source instanceof Member) {
            return StackTraceElements.forMember((Member)this.source).toString();
        }
        return this.source.toString();
    }

    public String toString() {
        Dependency<?> dep = this.getDependency();
        String source = this.getBindingSource();
        if (dep != null) {
            String string = String.valueOf(String.valueOf(dep));
            String string2 = String.valueOf(String.valueOf(source));
            return new StringBuilder(22 + string.length() + string2.length()).append("Dependency: ").append(string).append(", source: ").append(string2).toString();
        }
        String string = String.valueOf(String.valueOf(source));
        return new StringBuilder(8 + string.length()).append("Source: ").append(string).toString();
    }
}

