/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.pubsub.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.cloud.pubsub.v1.stub.PublisherStub;
import com.google.cloud.pubsub.v1.stub.PublisherStubSettings;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import com.google.pubsub.v1.UpdateTopicRequest;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TopicAdminClient
implements BackgroundResource {
    private final TopicAdminSettings settings;
    private final PublisherStub stub;

    public static final TopicAdminClient create() throws IOException {
        return TopicAdminClient.create(TopicAdminSettings.newBuilder().build());
    }

    public static final TopicAdminClient create(TopicAdminSettings settings) throws IOException {
        return new TopicAdminClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TopicAdminClient create(PublisherStub stub) {
        return new TopicAdminClient(stub);
    }

    protected TopicAdminClient(TopicAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PublisherStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TopicAdminClient(PublisherStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TopicAdminSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PublisherStub getStub() {
        return this.stub;
    }

    public final Topic createTopic(TopicName name) {
        Topic request = Topic.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.createTopic(request);
    }

    public final Topic createTopic(String name) {
        Topic request = Topic.newBuilder().setName(name).build();
        return this.createTopic(request);
    }

    public final Topic createTopic(ProjectTopicName name) {
        Topic request = Topic.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.createTopic(request);
    }

    public final Topic createTopic(Topic request) {
        return (Topic)this.createTopicCallable().call((Object)request);
    }

    public final UnaryCallable<Topic, Topic> createTopicCallable() {
        return this.stub.createTopicCallable();
    }

    public final Topic updateTopic(UpdateTopicRequest request) {
        return (Topic)this.updateTopicCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTopicRequest, Topic> updateTopicCallable() {
        return this.stub.updateTopicCallable();
    }

    final PublishResponse publish(TopicName topic, List<PubsubMessage> messages) {
        PublishRequest request = PublishRequest.newBuilder().setTopic(topic == null ? null : topic.toString()).addAllMessages(messages).build();
        return this.publish(request);
    }

    final PublishResponse publish(String topic, List<PubsubMessage> messages) {
        PublishRequest request = PublishRequest.newBuilder().setTopic(topic).addAllMessages(messages).build();
        return this.publish(request);
    }

    final PublishResponse publish(PublishRequest request) {
        return (PublishResponse)this.publishCallable().call((Object)request);
    }

    final UnaryCallable<PublishRequest, PublishResponse> publishCallable() {
        return this.stub.publishCallable();
    }

    public final Topic getTopic(TopicName topic) {
        GetTopicRequest request = GetTopicRequest.newBuilder().setTopic(topic == null ? null : topic.toString()).build();
        return this.getTopic(request);
    }

    public final Topic getTopic(String topic) {
        GetTopicRequest request = GetTopicRequest.newBuilder().setTopic(topic).build();
        return this.getTopic(request);
    }

    public final Topic getTopic(ProjectTopicName topic) {
        GetTopicRequest request = GetTopicRequest.newBuilder().setTopic(topic == null ? null : topic.toString()).build();
        return this.getTopic(request);
    }

    public final Topic getTopic(GetTopicRequest request) {
        return (Topic)this.getTopicCallable().call((Object)request);
    }

    public final UnaryCallable<GetTopicRequest, Topic> getTopicCallable() {
        return this.stub.getTopicCallable();
    }

    public final ListTopicsPagedResponse listTopics(ProjectName project) {
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setProject(project == null ? null : project.toString()).build();
        return this.listTopics(request);
    }

    public final ListTopicsPagedResponse listTopics(String project) {
        ListTopicsRequest request = ListTopicsRequest.newBuilder().setProject(project).build();
        return this.listTopics(request);
    }

    public final ListTopicsPagedResponse listTopics(ListTopicsRequest request) {
        return (ListTopicsPagedResponse)((Object)this.listTopicsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTopicsRequest, ListTopicsPagedResponse> listTopicsPagedCallable() {
        return this.stub.listTopicsPagedCallable();
    }

    public final UnaryCallable<ListTopicsRequest, ListTopicsResponse> listTopicsCallable() {
        return this.stub.listTopicsCallable();
    }

    public final ListTopicSubscriptionsPagedResponse listTopicSubscriptions(TopicName topic) {
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setTopic(topic == null ? null : topic.toString()).build();
        return this.listTopicSubscriptions(request);
    }

    public final ListTopicSubscriptionsPagedResponse listTopicSubscriptions(String topic) {
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setTopic(topic).build();
        return this.listTopicSubscriptions(request);
    }

    public final ListTopicSubscriptionsPagedResponse listTopicSubscriptions(ProjectTopicName topic) {
        ListTopicSubscriptionsRequest request = ListTopicSubscriptionsRequest.newBuilder().setTopic(topic == null ? null : topic.toString()).build();
        return this.listTopicSubscriptions(request);
    }

    public final ListTopicSubscriptionsPagedResponse listTopicSubscriptions(ListTopicSubscriptionsRequest request) {
        return (ListTopicSubscriptionsPagedResponse)((Object)this.listTopicSubscriptionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsPagedResponse> listTopicSubscriptionsPagedCallable() {
        return this.stub.listTopicSubscriptionsPagedCallable();
    }

    public final UnaryCallable<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> listTopicSubscriptionsCallable() {
        return this.stub.listTopicSubscriptionsCallable();
    }

    public final void deleteTopic(TopicName topic) {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setTopic(topic == null ? null : topic.toString()).build();
        this.deleteTopic(request);
    }

    public final void deleteTopic(String topic) {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setTopic(topic).build();
        this.deleteTopic(request);
    }

    public final void deleteTopic(ProjectTopicName topic) {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setTopic(topic == null ? null : topic.toString()).build();
        this.deleteTopic(request);
    }

    public final void deleteTopic(DeleteTopicRequest request) {
        this.deleteTopicCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteTopicRequest, Empty> deleteTopicCallable() {
        return this.stub.deleteTopicCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTopicSubscriptionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String, ListTopicSubscriptionsPage, ListTopicSubscriptionsFixedSizeCollection> {
        private ListTopicSubscriptionsFixedSizeCollection(List<ListTopicSubscriptionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTopicSubscriptionsFixedSizeCollection createEmptyCollection() {
            return new ListTopicSubscriptionsFixedSizeCollection(null, 0);
        }

        protected ListTopicSubscriptionsFixedSizeCollection createCollection(List<ListTopicSubscriptionsPage> pages, int collectionSize) {
            return new ListTopicSubscriptionsFixedSizeCollection(pages, collectionSize);
        }

        public Iterable<ProjectSubscriptionName> getValuesAsProjectSubscriptionName() {
            return Iterables.transform((Iterable)this.getValues(), (Function)new Function<String, ProjectSubscriptionName>(){

                public ProjectSubscriptionName apply(String arg0) {
                    return ProjectSubscriptionName.parse((String)arg0);
                }
            });
        }
    }

    public static class ListTopicSubscriptionsPage
    extends AbstractPage<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String, ListTopicSubscriptionsPage> {
        private ListTopicSubscriptionsPage(PageContext<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> context, ListTopicSubscriptionsResponse response) {
            super(context, (Object)response);
        }

        private static ListTopicSubscriptionsPage createEmptyPage() {
            return new ListTopicSubscriptionsPage(null, null);
        }

        protected ListTopicSubscriptionsPage createPage(PageContext<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> context, ListTopicSubscriptionsResponse response) {
            return new ListTopicSubscriptionsPage(context, response);
        }

        public ApiFuture<ListTopicSubscriptionsPage> createPageAsync(PageContext<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> context, ApiFuture<ListTopicSubscriptionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }

        public Iterable<ProjectSubscriptionName> iterateAllAsProjectSubscriptionName() {
            return Iterables.transform((Iterable)this.iterateAll(), (Function)new Function<String, ProjectSubscriptionName>(){

                public ProjectSubscriptionName apply(String arg0) {
                    return ProjectSubscriptionName.parse((String)arg0);
                }
            });
        }

        public Iterable<ProjectSubscriptionName> getValuesAsProjectSubscriptionName() {
            return Iterables.transform((Iterable)this.getValues(), (Function)new Function<String, ProjectSubscriptionName>(){

                public ProjectSubscriptionName apply(String arg0) {
                    return ProjectSubscriptionName.parse((String)arg0);
                }
            });
        }
    }

    public static class ListTopicSubscriptionsPagedResponse
    extends AbstractPagedListResponse<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String, ListTopicSubscriptionsPage, ListTopicSubscriptionsFixedSizeCollection> {
        public static ApiFuture<ListTopicSubscriptionsPagedResponse> createAsync(PageContext<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse, String> context, ApiFuture<ListTopicSubscriptionsResponse> futureResponse) {
            ApiFuture<ListTopicSubscriptionsPage> futurePage = ListTopicSubscriptionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTopicSubscriptionsPage, ListTopicSubscriptionsPagedResponse>(){

                public ListTopicSubscriptionsPagedResponse apply(ListTopicSubscriptionsPage input) {
                    return new ListTopicSubscriptionsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTopicSubscriptionsPagedResponse(ListTopicSubscriptionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTopicSubscriptionsFixedSizeCollection.createEmptyCollection());
        }

        public Iterable<ProjectSubscriptionName> iterateAllAsProjectSubscriptionName() {
            return Iterables.transform((Iterable)this.iterateAll(), (Function)new Function<String, ProjectSubscriptionName>(){

                public ProjectSubscriptionName apply(String arg0) {
                    return ProjectSubscriptionName.parse((String)arg0);
                }
            });
        }
    }

    public static class ListTopicsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTopicsRequest, ListTopicsResponse, Topic, ListTopicsPage, ListTopicsFixedSizeCollection> {
        private ListTopicsFixedSizeCollection(List<ListTopicsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTopicsFixedSizeCollection createEmptyCollection() {
            return new ListTopicsFixedSizeCollection(null, 0);
        }

        protected ListTopicsFixedSizeCollection createCollection(List<ListTopicsPage> pages, int collectionSize) {
            return new ListTopicsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTopicsPage
    extends AbstractPage<ListTopicsRequest, ListTopicsResponse, Topic, ListTopicsPage> {
        private ListTopicsPage(PageContext<ListTopicsRequest, ListTopicsResponse, Topic> context, ListTopicsResponse response) {
            super(context, (Object)response);
        }

        private static ListTopicsPage createEmptyPage() {
            return new ListTopicsPage(null, null);
        }

        protected ListTopicsPage createPage(PageContext<ListTopicsRequest, ListTopicsResponse, Topic> context, ListTopicsResponse response) {
            return new ListTopicsPage(context, response);
        }

        public ApiFuture<ListTopicsPage> createPageAsync(PageContext<ListTopicsRequest, ListTopicsResponse, Topic> context, ApiFuture<ListTopicsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTopicsPagedResponse
    extends AbstractPagedListResponse<ListTopicsRequest, ListTopicsResponse, Topic, ListTopicsPage, ListTopicsFixedSizeCollection> {
        public static ApiFuture<ListTopicsPagedResponse> createAsync(PageContext<ListTopicsRequest, ListTopicsResponse, Topic> context, ApiFuture<ListTopicsResponse> futureResponse) {
            ApiFuture<ListTopicsPage> futurePage = ListTopicsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTopicsPage, ListTopicsPagedResponse>(){

                public ListTopicsPagedResponse apply(ListTopicsPage input) {
                    return new ListTopicsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTopicsPagedResponse(ListTopicsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTopicsFixedSizeCollection.createEmptyCollection());
        }
    }
}

