/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.util;

import com.github.pfmiles.dropincc.CC;
import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.Element;
import com.github.pfmiles.dropincc.Grule;
import com.github.pfmiles.dropincc.TokenDef;
import com.github.pfmiles.dropincc.impl.AndSubRule;
import com.github.pfmiles.dropincc.impl.ConstructingGrule;
import com.github.pfmiles.dropincc.impl.EleType;
import com.github.pfmiles.dropincc.impl.OrSubRule;
import com.github.pfmiles.dropincc.impl.TypeMappingParam;
import com.github.pfmiles.dropincc.impl.kleene.AbstractKleeneNode;
import com.github.pfmiles.dropincc.impl.lexical.InstantTokenDef;
import com.github.pfmiles.dropincc.impl.util.SetStack;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Util {
    public static final String PATH_SEP = "/";

    private Util() {
    }

    public static boolean isEmpty(String str) {
        return null == str || "".equals(str);
    }

    public static Element[] filterProductionEles(Object[] eles) {
        if (eles == null) {
            return null;
        }
        Element[] eleNoCon = new Element[eles.length];
        for (int i = 0; i < eles.length; ++i) {
            Object ele = eles[i];
            if (ele instanceof ConstructingGrule) {
                eleNoCon[i] = ((ConstructingGrule)ele).getGrule();
                continue;
            }
            if (ele.equals(CC.NOTHING)) {
                if (eles.length == 1) continue;
                throw new DropinccException("Alternative production which contains 'CC.NOTHING' could not have any other elements(Because this is an 'empty' alternative production.)");
            }
            if (ele instanceof Element) {
                eleNoCon[i] = (Element)ele;
                continue;
            }
            if (ele instanceof String) {
                eleNoCon[i] = new InstantTokenDef((String)ele);
                continue;
            }
            throw new DropinccException("Illegal production element type: " + ele);
        }
        return eleNoCon;
    }

    public static EleType resolveEleType(Element e, TypeMappingParam param) {
        Class<?> eleCls = e.getClass();
        EleType t = null;
        if (AndSubRule.class.isAssignableFrom(eleCls)) {
            throw new DropinccException("AndSubRule shouldn't exist when resolving element types, it should be already rewrited in prior steps.");
        }
        if (ConstructingGrule.class.isAssignableFrom(eleCls)) {
            throw new DropinccException("There must be something wrong, ConstructingGrule shouldn't appear here.");
        }
        if (Grule.class.isAssignableFrom(eleCls)) {
            t = param.getGruleTypeMapping().get(e);
        } else {
            if (OrSubRule.class.isAssignableFrom(eleCls)) {
                throw new DropinccException("OrSubRule shouldn't exist when resolving element types, it should be already rewrited in prior steps.");
            }
            if (TokenDef.class.isAssignableFrom(eleCls)) {
                t = param.getTokenTypeMapping().get(e);
            } else if (e.equals(CC.NOTHING)) {
                t = param.getSpecialTypeMapping().get(e);
            } else if (AbstractKleeneNode.class.isAssignableFrom(eleCls)) {
                t = param.getKleeneTypeMapping().get(e);
            } else {
                throw new DropinccException("Unhandled element: " + e);
            }
        }
        if (t == null) {
            throw new DropinccException("Could not resolve element type for element: " + e + ", is this element defined in a proper manner?");
        }
        return t;
    }

    public static String resolveActionName(Object action) {
        if (action == null) {
            return null;
        }
        Class<?> cls = action.getClass();
        String name = cls.getSimpleName();
        if (name != null && !"".equals(name)) {
            return name;
        }
        name = cls.getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public static <K, V> Map<V, K> reverseMap(Map<K, V> map) {
        HashMap<V, K> ret = new HashMap<V, K>();
        for (Map.Entry<K, V> e : map.entrySet()) {
            ret.put(e.getValue(), e.getKey());
        }
        return ret;
    }

    public static String dumpCirclePath(SetStack<?> path, Object t) {
        StringBuilder sb = new StringBuilder();
        Iterator nodes = path.iterator();
        Object n = nodes.next();
        while (nodes.hasNext() && !t.equals(n)) {
            n = nodes.next();
        }
        sb.append(n.toString());
        while (nodes.hasNext()) {
            sb.append(" -> ").append(nodes.next().toString());
        }
        sb.append(" -> ").append(t.toString());
        return sb.toString();
    }

    public static String showHiddenChars(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isISOControl(c) || Character.isWhitespace(c)) {
                sb.append("\\").append((int)c);
                continue;
            }
            if ('\\' == c) {
                sb.append("\\\\");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static int minInt(Collection<Integer> ints) {
        int ret = Integer.MAX_VALUE;
        for (int i : ints) {
            if (i >= ret) continue;
            ret = i;
        }
        return ret;
    }

    public static String join(String joint, List<String> elements) {
        StringBuilder sb = new StringBuilder();
        for (String ele : elements) {
            if (sb.length() != 0) {
                sb.append(joint);
            }
            sb.append(ele);
        }
        return sb.toString();
    }

    public static String getClassPath() {
        URL url;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            String k = (String)e.getKey();
            if (!k.endsWith("class.path")) continue;
            if (sb.length() != 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(e.getValue());
        }
        ClassLoader loader = Util.getParentClsLoader();
        if (loader instanceof URLClassLoader) {
            for (URL url2 : ((URLClassLoader)loader).getURLs()) {
                String dropinccPath = Util.toFilePath(url2);
                if (dropinccPath == null || "".equals(dropinccPath) || sb.indexOf(dropinccPath) != -1) continue;
                if (sb.length() != 0) {
                    sb.append(File.pathSeparator);
                }
                sb.append(dropinccPath);
            }
        }
        if ((url = Util.class.getResource("Util.class")) != null) {
            String dropinccPath = null;
            if ("jar".equalsIgnoreCase(url.getProtocol())) {
                String path = Util.toFilePath(url);
                dropinccPath = path != null ? path.substring(path.indexOf(":") + 1, path.indexOf("!")) : null;
            } else if ("file".equalsIgnoreCase(url.getProtocol())) {
                String path = Util.toFilePath(url);
                String string = dropinccPath = path != null ? path.substring(0, path.lastIndexOf(PATH_SEP + Util.class.getName().replace(".", PATH_SEP) + ".class")) : null;
            }
            if (dropinccPath != null && !"".equals(dropinccPath) && sb.indexOf(dropinccPath) == -1) {
                if (sb.length() != 0) {
                    sb.append(File.pathSeparator);
                }
                sb.append(dropinccPath);
            }
        }
        return sb.toString();
    }

    private static String toFilePath(URL url) {
        String protocal = url.getProtocol();
        if (!"jar".equalsIgnoreCase(protocal) && !"file".equalsIgnoreCase(protocal)) {
            return null;
        }
        try {
            File f = new File(url.toURI().getSchemeSpecificPart());
            if (f.exists()) {
                return f.toURI().getSchemeSpecificPart();
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new DropinccException(e);
        }
    }

    public static ClassLoader getParentClsLoader() {
        ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
        if (ctxLoader != null) {
            try {
                ctxLoader.loadClass(Util.class.getName());
                return ctxLoader;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Util.class.getClassLoader();
    }
}

