/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.util;

import java.util.Arrays;

public class ByteAppender {
    private byte[] buf = new byte[1024];
    private int count = 0;

    public void append(byte[] b, int off, int len) {
        if (off < 0 || off >= b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void append(byte[] b) {
        this.append(b, 0, b.length);
    }

    public byte[] toByteArray() {
        byte[] ret = new byte[this.count];
        System.arraycopy(this.buf, 0, ret, 0, this.count);
        return ret;
    }
}

