/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.syntactical.codegen.rulemethods.code;

import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.impl.EleType;
import com.github.pfmiles.dropincc.impl.GruleType;
import com.github.pfmiles.dropincc.impl.TokenType;
import com.github.pfmiles.dropincc.impl.kleene.KleeneType;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGen;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGenContext;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.rulemethods.code.KleeneEleGen;
import com.github.pfmiles.dropincc.impl.util.Pair;
import com.github.pfmiles.dropincc.impl.util.Util;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class ElementsCodeGen
extends CodeGen {
    private static final String multiVarFmt = ElementsCodeGen.getTemplate("multiVar.dt", ElementsCodeGen.class);
    private static final String multiVarBacktrackFmt = ElementsCodeGen.getTemplate("multiVarBacktrack.dt", ElementsCodeGen.class);
    private static final String tokenMatchFmt = "Object {0} = this.match({1});";
    private static final String ruleIvkFmt = "Object {0} = {1}(arg);";
    private List<EleType> matchSeq;
    private boolean generatingBacktrackCode;

    public ElementsCodeGen(List<EleType> matchSequence, boolean generatingBacktrackCode) {
        this.matchSeq = matchSequence;
        this.generatingBacktrackCode = generatingBacktrackCode;
    }

    public Pair<String, String> render(CodeGenContext context) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> vars = new ArrayList<String>();
        for (EleType ele : this.matchSeq) {
            String varName;
            if (ele instanceof TokenType) {
                varName = "p" + context.varSeq.next();
                sb.append(MessageFormat.format(tokenMatchFmt, varName, ((TokenType)ele).toCodeGenStr())).append('\n');
                vars.add(varName);
                continue;
            }
            if (ele instanceof GruleType) {
                varName = "p" + context.varSeq.next();
                sb.append(MessageFormat.format(ruleIvkFmt, varName, ((GruleType)ele).toCodeGenStr())).append('\n');
                vars.add(varName);
                continue;
            }
            if (ele instanceof KleeneType) {
                Object varAndCode = new KleeneEleGen(context.kleeneTypeToPredicting.get((KleeneType)ele), this.generatingBacktrackCode).render(context);
                vars.add((String)((Pair)varAndCode).getLeft());
                sb.append((String)((Pair)varAndCode).getRight());
                continue;
            }
            throw new DropinccException("Unsupported code generation element type: " + ele);
        }
        String retVar = null;
        if (vars.size() == 1) {
            retVar = (String)vars.get(0);
        } else if (vars.size() > 1) {
            String ctt = Util.join(", ", vars);
            retVar = "p" + context.varSeq.next();
            if (this.generatingBacktrackCode) {
                sb.append(MessageFormat.format(multiVarBacktrackFmt, retVar, ctt)).append('\n');
            } else {
                sb.append(MessageFormat.format(multiVarFmt, retVar, ctt)).append('\n');
            }
        }
        return new Pair<String, String>(retVar, sb.toString());
    }
}

