/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.syntactical.codegen.rulemethods;

import com.github.pfmiles.dropincc.Action;
import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.ParamedAction;
import com.github.pfmiles.dropincc.impl.CAlternative;
import com.github.pfmiles.dropincc.impl.llstar.PredictingGrule;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGen;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGenContext;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.rulemethods.code.ElementsCodeGen;
import com.github.pfmiles.dropincc.impl.util.Pair;
import java.text.MessageFormat;

public class SingleAltMatchCodeGen
extends CodeGen {
    private static final String fmt = "{0}\nret = {1};";
    private static final String fmtOnBacktrackPath = SingleAltMatchCodeGen.getTemplate("singleAltMatchOnBacktrackPath.dt", SingleAltMatchCodeGen.class);
    private static final String actionIvkFmt = "{0}.act({1})";
    private static final String paramedActionFmt = "{0}.act(arg, {1})";
    private PredictingGrule pg;
    private boolean onBacktrackPath;

    public SingleAltMatchCodeGen(PredictingGrule pg, boolean onBacktrackPath) {
        this.pg = pg;
        this.onBacktrackPath = onBacktrackPath;
    }

    public String render(CodeGenContext context) {
        CAlternative alt = this.pg.getAlts().get(0);
        Object varAndCode = new ElementsCodeGen(alt.getMatchSequence(), this.onBacktrackPath).render(context);
        String elementsCode = (String)((Pair)varAndCode).getRight();
        String elementsVar = (String)((Pair)varAndCode).getLeft();
        String actionName = "null";
        String actionIvk = elementsVar;
        if (alt.getAction() != null) {
            actionName = context.actionFieldMapping.get(alt.getAction());
            if (alt.getAction() instanceof Action) {
                actionIvk = MessageFormat.format(actionIvkFmt, actionName, elementsVar);
            } else if (alt.getAction() instanceof ParamedAction) {
                actionIvk = MessageFormat.format(paramedActionFmt, actionName, elementsVar);
            } else {
                throw new DropinccException("Illegal action type: " + alt.getAction().getClass());
            }
        }
        if (this.onBacktrackPath) {
            return MessageFormat.format(fmtOnBacktrackPath, String.valueOf(this.pg.getGruleType().getDefIndex()), elementsCode, elementsVar, actionName);
        }
        return MessageFormat.format(fmt, elementsCode, actionIvk);
    }
}

