/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.syntactical.codegen.rulemethods;

import com.github.pfmiles.dropincc.Action;
import com.github.pfmiles.dropincc.DropinccException;
import com.github.pfmiles.dropincc.ParamedAction;
import com.github.pfmiles.dropincc.impl.CAlternative;
import com.github.pfmiles.dropincc.impl.llstar.PredictingGrule;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGen;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGenContext;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.rulemethods.code.ElementsCodeGen;
import com.github.pfmiles.dropincc.impl.util.Pair;
import java.text.MessageFormat;

public class MultiAltMatchCodeGen
extends CodeGen {
    private static final String fmt = MultiAltMatchCodeGen.getTemplate("multiAltMatchCode.dt", MultiAltMatchCodeGen.class);
    private static final String altCase = MultiAltMatchCodeGen.getTemplate("altCase.dt", MultiAltMatchCodeGen.class);
    private static final String altCaseOnBacktrackPath = MultiAltMatchCodeGen.getTemplate("altCaseOnBacktrackPath.dt", MultiAltMatchCodeGen.class);
    private static final String actionIvkFormat = "{0}.act({1})";
    private static final String paramedActionIvkFormat = "{0}.act(arg, {1})";
    private PredictingGrule pg;
    private boolean generatingBacktrackCode;

    public MultiAltMatchCodeGen(PredictingGrule pg, boolean generatingBacktrackCode) {
        this.pg = pg;
        this.generatingBacktrackCode = generatingBacktrackCode;
    }

    public String render(CodeGenContext context) {
        StringBuilder altsSwitchCode = new StringBuilder();
        for (int i = 0; i < this.pg.getAlts().size(); ++i) {
            String elementsVar;
            CAlternative alt = this.pg.getAlts().get(i);
            String altNum = String.valueOf(i);
            Object varAndCode = new ElementsCodeGen(alt.getMatchSequence(), this.generatingBacktrackCode).render(context);
            String elementsCode = (String)((Pair)varAndCode).getRight();
            String actionIvk = elementsVar = (String)((Pair)varAndCode).getLeft();
            String actionName = "null";
            if (alt.getAction() != null) {
                actionName = context.actionFieldMapping.get(alt.getAction());
                if (alt.getAction() instanceof ParamedAction) {
                    actionIvk = MessageFormat.format(paramedActionIvkFormat, actionName, elementsVar);
                } else if (alt.getAction() instanceof Action) {
                    actionIvk = MessageFormat.format(actionIvkFormat, actionName, elementsVar);
                } else {
                    throw new DropinccException("Illegal action type: " + alt.getAction().getClass());
                }
            }
            if (this.generatingBacktrackCode) {
                altsSwitchCode.append(MessageFormat.format(altCaseOnBacktrackPath, altNum, elementsCode, elementsVar, actionName, String.valueOf(this.pg.getGruleType().getDefIndex()))).append('\n');
                continue;
            }
            altsSwitchCode.append(MessageFormat.format(altCase, altNum, elementsCode, actionIvk)).append('\n');
        }
        return MessageFormat.format(fmt, this.pg.getGruleType().toCodeGenStr(), altsSwitchCode.toString());
    }
}

