/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.syntactical.codegen.rulemethods;

import com.github.pfmiles.dropincc.impl.CAlternative;
import com.github.pfmiles.dropincc.impl.llstar.PredictingGrule;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGen;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGenContext;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.rulemethods.code.ElementsCodeGen;
import com.github.pfmiles.dropincc.impl.util.Pair;
import java.text.MessageFormat;

public class MultiAltMatchBacktrackGen
extends CodeGen {
    private static final String fmt = MultiAltMatchBacktrackGen.getTemplate("multiAltBacktrackMatchCode.dt", MultiAltMatchBacktrackGen.class);
    private static final String altBacktrackFmt = MultiAltMatchBacktrackGen.getTemplate("altBacktrack.dt", MultiAltMatchBacktrackGen.class);
    private static final String altBacktrackOnPathFmt = MultiAltMatchBacktrackGen.getTemplate("altBacktrackOnPath.dt", MultiAltMatchBacktrackGen.class);
    private PredictingGrule pg;
    private boolean generatingBacktrackCode;

    public MultiAltMatchBacktrackGen(PredictingGrule pg, boolean generatingBacktrackCode) {
        this.pg = pg;
        this.generatingBacktrackCode = generatingBacktrackCode;
    }

    public String render(CodeGenContext context) {
        String ruleName = this.pg.getGruleType().toCodeGenStr();
        StringBuilder backtrackCode = new StringBuilder();
        String ruleNum = String.valueOf(this.pg.getGruleType().getDefIndex());
        for (CAlternative alt : this.pg.getAlts()) {
            Object varAndCode = new ElementsCodeGen(alt.getMatchSequence(), true).render(context);
            String actionName = "null";
            if (alt.getAction() != null) {
                actionName = context.actionFieldMapping.get(alt.getAction());
            }
            if (this.generatingBacktrackCode) {
                backtrackCode.append(MessageFormat.format(altBacktrackOnPathFmt, ruleNum, ((Pair)varAndCode).getRight(), ((Pair)varAndCode).getLeft(), actionName)).append('\n');
                continue;
            }
            backtrackCode.append(MessageFormat.format(altBacktrackFmt, ruleNum, ((Pair)varAndCode).getRight(), ((Pair)varAndCode).getLeft(), actionName)).append('\n');
        }
        String cleanCacheCode = "";
        if (!this.generatingBacktrackCode) {
            cleanCacheCode = "cleanCache();";
        }
        return MessageFormat.format(fmt, ruleName, backtrackCode.toString(), cleanCacheCode);
    }
}

