/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.syntactical.codegen;

import com.github.pfmiles.dropincc.Predicate;
import com.github.pfmiles.dropincc.impl.TokenType;
import com.github.pfmiles.dropincc.impl.llstar.DfaState;
import com.github.pfmiles.dropincc.impl.llstar.LookAheadDfa;
import com.github.pfmiles.dropincc.impl.llstar.PredictingGrule;
import com.github.pfmiles.dropincc.impl.runtime.impl.RunningDfaState;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGen;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGenContext;
import com.github.pfmiles.dropincc.impl.util.SeqGen;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RuleDfasGen
extends CodeGen {
    private static final String fmt = "public RunningDfaState {0}DfaStart;// {0} rule look ahead dfa start state";
    private List<PredictingGrule> pgs;

    public RuleDfasGen(List<PredictingGrule> pgs) {
        this.pgs = pgs;
    }

    public String render(CodeGenContext context) {
        StringBuilder sb = new StringBuilder();
        for (PredictingGrule p : this.pgs) {
            if (p.getDfa() == null) continue;
            String ruleName = p.getGruleType().toCodeGenStr();
            sb.append(MessageFormat.format(fmt, ruleName)).append('\n');
            String dfaName = ruleName + "DfaStart";
            RunningDfaState start = this.toPredictingDfa(p.getDfa());
            context.fieldRuleDfaMapping.put(dfaName, start);
        }
        return sb.toString();
    }

    private RunningDfaState toPredictingDfa(LookAheadDfa d) {
        HashMap<DfaState, Integer> stateNumMapping = new HashMap<DfaState, Integer>();
        SeqGen seq = new SeqGen();
        DfaState s0 = d.getStart();
        stateNumMapping.put(s0, seq.next());
        for (DfaState s : d.getStates()) {
            if (s.equals(s0)) continue;
            stateNumMapping.put(s, seq.next());
        }
        RunningDfaState start = null;
        HashMap<RunningDfaState, RunningDfaState> ds = new HashMap<RunningDfaState, RunningDfaState>();
        for (Map.Entry e : stateNumMapping.entrySet()) {
            RunningDfaState destRstate;
            int destNum;
            HashMap trans;
            DfaState s = (DfaState)e.getKey();
            RunningDfaState rs = this.resolveRunningState((Integer)e.getValue(), ds);
            if (rs.state == 0) {
                start = rs;
            }
            if (s.isFinal()) {
                rs.isFinal = true;
                rs.alt = s.getAlt();
                continue;
            }
            rs.isPredTransitionState = this.isPredicateTransState(s.getTransitions());
            if (rs.isPredTransitionState) {
                trans = new HashMap();
                for (Map.Entry<Object, DfaState> t : s.getTransitions().entrySet()) {
                    destNum = (Integer)stateNumMapping.get(t.getValue());
                    destRstate = this.resolveRunningState(destNum, ds);
                    trans.put((Predicate)t.getKey(), destRstate);
                }
                rs.predTrans = trans;
                continue;
            }
            trans = new HashMap();
            for (Map.Entry<Object, DfaState> t : s.getTransitions().entrySet()) {
                destNum = (Integer)stateNumMapping.get(t.getValue());
                destRstate = this.resolveRunningState(destNum, ds);
                trans.put((Predicate<?>)((Object)((TokenType)t.getKey())), destRstate);
            }
            rs.transitions = trans;
        }
        return start;
    }

    private RunningDfaState resolveRunningState(Integer state, Map<RunningDfaState, RunningDfaState> ds) {
        RunningDfaState s = new RunningDfaState();
        s.state = state;
        if (ds.containsKey(s)) {
            return ds.get(s);
        }
        ds.put(s, s);
        return s;
    }

    private boolean isPredicateTransState(Map<Object, DfaState> transitions) {
        for (Object t : transitions.keySet()) {
            if (t instanceof Predicate) continue;
            return false;
        }
        return true;
    }
}

