/*
 * Decompiled with CFR 0.152.
 */
package com.github.pfmiles.dropincc.impl.syntactical.codegen;

import com.github.pfmiles.dropincc.impl.TokenType;
import com.github.pfmiles.dropincc.impl.llstar.DfaState;
import com.github.pfmiles.dropincc.impl.llstar.LookAheadDfa;
import com.github.pfmiles.dropincc.impl.llstar.PredictingKleene;
import com.github.pfmiles.dropincc.impl.runtime.impl.RunningDfaState;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGen;
import com.github.pfmiles.dropincc.impl.syntactical.codegen.CodeGenContext;
import com.github.pfmiles.dropincc.impl.util.SeqGen;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KleeneDfasGen
extends CodeGen {
    private static final String fmt = "public RunningDfaState {0}DfaStart;";
    private List<PredictingKleene> pks;

    public KleeneDfasGen(List<PredictingKleene> kleeneTypeToDfa) {
        this.pks = kleeneTypeToDfa;
    }

    public String render(CodeGenContext context) {
        StringBuilder sb = new StringBuilder();
        for (PredictingKleene pk : this.pks) {
            if (pk.isBacktrack()) continue;
            sb.append(MessageFormat.format(fmt, pk.getKleeneType().toCodeGenStr())).append('\n');
            String fieldName = pk.getKleeneType().toCodeGenStr() + "DfaStart";
            context.fieldKleeneDfaMapping.put(fieldName, this.toPredictingDfa(pk.getDfa()));
        }
        return sb.toString();
    }

    private RunningDfaState toPredictingDfa(LookAheadDfa d) {
        HashMap<DfaState, Integer> stateNumMapping = new HashMap<DfaState, Integer>();
        SeqGen seq = new SeqGen();
        DfaState s0 = d.getStart();
        stateNumMapping.put(s0, seq.next());
        for (DfaState s : d.getStates()) {
            if (s.equals(s0)) continue;
            stateNumMapping.put(s, seq.next());
        }
        RunningDfaState start = null;
        HashMap<RunningDfaState, RunningDfaState> ds = new HashMap<RunningDfaState, RunningDfaState>();
        for (Map.Entry e : stateNumMapping.entrySet()) {
            DfaState s = (DfaState)e.getKey();
            RunningDfaState rstate = this.resolveRunningState((Integer)e.getValue(), ds);
            if (rstate.state == 0) {
                start = rstate;
            }
            if (s.isFinal()) {
                rstate.isFinal = true;
                rstate.alt = s.getAlt();
                continue;
            }
            HashMap<TokenType, RunningDfaState> trans = new HashMap<TokenType, RunningDfaState>();
            for (Map.Entry<Object, DfaState> t : s.getTransitions().entrySet()) {
                int destNum = (Integer)stateNumMapping.get(t.getValue());
                RunningDfaState destRstate = this.resolveRunningState(destNum, ds);
                trans.put((TokenType)t.getKey(), destRstate);
            }
            rstate.transitions = trans;
        }
        return start;
    }

    private RunningDfaState resolveRunningState(Integer state, Map<RunningDfaState, RunningDfaState> ds) {
        RunningDfaState s = new RunningDfaState();
        s.state = state;
        if (ds.containsKey(s)) {
            return ds.get(s);
        }
        ds.put(s, s);
        return s;
    }
}

